/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.ICrosshairRenderer;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.mixins.GuiAccessor;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11631;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class CrosshairRenderer
implements ICrosshairRenderer {
    private static final class_2960 OBSTRUCTION_INDICATOR_SPRITE = class_2960.method_60655((String)"shouldersurfing", (String)"hud/obstruction_indicator");
    private static final class_2960 OBSTRUCTED_CROSSHAIR_SPRITE = class_2960.method_60655((String)"shouldersurfing", (String)"hud/obstructed_crosshair");
    private static final class_2960 OBSTRUCTED_CROSSHAIR_CROSS_SPRITE = class_2960.method_60655((String)"shouldersurfing", (String)"hud/obstructed_crosshair_cross");
    private final ShoulderSurfingImpl instance;
    private Vec2f crosshairOffset;

    public CrosshairRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
        this.init();
    }

    private void init() {
        this.crosshairOffset = null;
    }

    public void preRenderCrosshair(class_332 guiGraphics) {
        boolean isDynamic = this.isCrosshairDynamic(class_310.method_1551().method_1560());
        if (isDynamic || this.doRenderObstructionCrosshair()) {
            this.setupPoseStack(guiGraphics.method_51448());
        }
    }

    public void postRenderCrosshair(class_332 guiGraphics) {
        boolean doRenderObstructionCrosshair = this.doRenderObstructionCrosshair();
        boolean isDynamic = this.isCrosshairDynamic(class_310.method_1551().method_1560());
        if (isDynamic || doRenderObstructionCrosshair) {
            this.resetPoseStack(guiGraphics.method_51448());
        }
        if (doRenderObstructionCrosshair) {
            this.renderObstructionCrosshair(guiGraphics);
        } else if (this.doRenderObstructionIndicator()) {
            this.setupPoseStack(guiGraphics.method_51448());
            this.renderObstructionIndicator(guiGraphics);
            this.resetPoseStack(guiGraphics.method_51448());
        }
    }

    private void setupPoseStack(Matrix3x2fStack poseStack) {
        if (this.crosshairOffset != null) {
            poseStack.pushMatrix();
            poseStack.translate(this.crosshairOffset.x(), -this.crosshairOffset.y());
        }
    }

    private void resetPoseStack(Matrix3x2fStack poseStack) {
        if (this.crosshairOffset != null) {
            poseStack.popMatrix();
        }
    }

    @Override
    public boolean doRenderCrosshair() {
        return Config.CLIENT.getCrosshairVisibility(Perspective.current()).doRender(class_310.method_1551().field_1765, this.instance.isAiming()) && (this.crosshairOffset != null || !this.isCrosshairDynamic(class_310.method_1551().method_1560()));
    }

    @Override
    public boolean doRenderObstructionCrosshair() {
        return this.doRenderObstructionIndicator() && this.instance.isAiming() && !class_310.method_1551().field_61504.method_72772(class_11631.field_61583);
    }

    @Override
    public boolean doRenderObstructionIndicator() {
        int minDistanceToCrosshair = Config.CLIENT.getObstructionIndicatorMinDistanceToCrosshair();
        return this.crosshairOffset != null && this.instance.isShoulderSurfing() && Config.CLIENT.getShowObstructionCrosshair() && (this.instance.isAiming() || !Config.CLIENT.showObstructionIndicatorWhenAiming()) && !this.isCrosshairDynamic(class_310.method_1551().method_1560()) && this.crosshairOffset.lengthSquared() >= (double)(minDistanceToCrosshair * minDistanceToCrosshair);
    }

    public void updateDynamicRaytrace(class_4184 camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float partialTick) {
        if (this.instance.isShoulderSurfing() && class_310.method_1551().field_1724 != null) {
            boolean isDynamic = this.isCrosshairDynamic(class_310.method_1551().method_1560());
            double interactionRangeOverride = Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
            class_746 player = class_310.method_1551().field_1724;
            PickContext.Builder pickContextBuilder = new PickContext.Builder(camera);
            if (isDynamic) {
                pickContextBuilder.dynamicTrace();
            }
            PickContext pickContext = pickContextBuilder.build();
            class_239 hitResult = this.instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, (class_1657)player);
            class_243 position = hitResult.method_17784();
            if (!isDynamic) {
                pickContext = pickContextBuilder.obstructionTrace(position).build();
                hitResult = this.instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, (class_1657)player);
                position = hitResult.method_17784();
            }
            Vec2f projected = CrosshairRenderer.project2D(position.method_1020(camera.method_19326()), modelViewMatrix, projectionMatrix);
            Vec2f crosshairOffset = null;
            if (projected != null) {
                class_1041 window = class_310.method_1551().method_22683();
                Vec2f screenSize = new Vec2f(window.method_4480(), window.method_4507());
                Vec2f center = screenSize.divide(2.0f);
                double maxDistanceToObstruction = Config.CLIENT.getObstructionIndicatorMaxDistanceToObstruction();
                if (isDynamic || !Config.CLIENT.getShowObstructionCrosshair() || maxDistanceToObstruction <= 0.0 || position.method_1025(player.method_33571()) <= maxDistanceToObstruction * maxDistanceToObstruction) {
                    crosshairOffset = projected.subtract(center).divide(window.method_4495());
                }
            }
            this.crosshairOffset = crosshairOffset;
        }
    }

    @Override
    public boolean isCrosshairDynamic(class_1297 entity) {
        return this.instance.isShoulderSurfing() && Config.CLIENT.getCrosshairType().isDynamic(entity, this.instance.isAiming());
    }

    private void renderObstructionCrosshair(class_332 guiGraphics) {
        this.renderCustomCrosshair(guiGraphics, OBSTRUCTED_CROSSHAIR_SPRITE, class_10799.field_56890);
        this.renderCustomCrosshair(guiGraphics, OBSTRUCTED_CROSSHAIR_CROSS_SPRITE, class_10799.field_56883);
    }

    private void renderObstructionIndicator(class_332 guiGraphics) {
        this.renderCustomCrosshair(guiGraphics, OBSTRUCTION_INDICATOR_SPRITE, class_10799.field_56890);
    }

    private void renderCustomCrosshair(class_332 guiGraphics, class_2960 sprite, RenderPipeline renderPipeline) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1761.method_2920() != class_1934.field_9219 || ((GuiAccessor)minecraft.field_1705).invokeCanRenderCrosshairForSpectator(minecraft.field_1765)) {
            guiGraphics.method_52706(renderPipeline, sprite, (guiGraphics.method_51421() - 15) / 2, (guiGraphics.method_51443() - 15) / 2, 15, 15);
        }
    }

    public void resetState() {
        this.init();
    }

    @Nullable
    private static Vec2f project2D(class_243 position, Matrix4f modelView, Matrix4f projection) {
        class_1041 window = class_310.method_1551().method_22683();
        int screenWidth = window.method_4480();
        int screenHeight = window.method_4507();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        Vector4f vec = new Vector4f((float)position.method_10216(), (float)position.method_10214(), (float)position.method_10215(), 1.0f);
        vec.mul((Matrix4fc)modelView);
        vec.mul((Matrix4fc)projection);
        if (vec.w() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.w() * 0.5f;
        float x = (vec.x() * w + 0.5f) * (float)screenWidth;
        float y = (vec.y() * w + 0.5f) * (float)screenHeight;
        float z = vec.z() * w + 0.5f;
        vec.set(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y) || w < 0.0f) {
            return null;
        }
        return new Vec2f(x, y);
    }
}

