/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigNotifiable;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;

public enum FeatureToggle implements IHotkeyTogglable,
IConfigNotifiable<IConfigBoolean>
{
    TWEAK_ACCURATE_BLOCK_PLACEMENT("tweakAccurateBlockPlacement", false, ""),
    TWEAK_AFTER_CLICKER("tweakAfterClicker", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_AIM_LOCK("tweakAimLock", false, ""),
    TWEAK_ANGEL_BLOCK("tweakAngelBlock", false, ""),
    TWEAK_AREA_SELECTOR("tweakAreaSelector", false, ""),
    TWEAK_AUTO_SWITCH_ELYTRA("tweakAutoSwitchElytra", false, ""),
    TWEAK_BLOCK_REACH_OVERRIDE("tweakBlockReachOverride", false, true, ""),
    TWEAK_BLOCK_TYPE_BREAK_RESTRICTION("tweakBlockTypeBreakRestriction", false, ""),
    TWEAK_BREAKING_GRID("tweakBreakingGrid", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_BREAKING_RESTRICTION("tweakBreakingRestriction", false, ""),
    TWEAK_BREAK_REPLACE("tweakBreakReplace", false, ""),
    TWEAK_BUNDLE_DISPLAY("tweakBundleDisplay", false, ""),
    TWEAK_CHAT_BACKGROUND_COLOR("tweakChatBackgroundColor", false, ""),
    TWEAK_CHAT_PERSISTENT_TEXT("tweakChatPersistentText", false, ""),
    TWEAK_CHAT_TIMESTAMP("tweakChatTimestamp", false, ""),
    TWEAK_COMMAND_BLOCK_EXTRA_FIELDS("tweakCommandBlockExtraFields", false, ""),
    TWEAK_CUSTOM_FLY_DECELERATION("tweakCustomFlyDeceleration", false, ""),
    TWEAK_CUSTOM_INVENTORY_GUI_SCALE("tweakCustomInventoryScreenScale", false, ""),
    TWEAK_DARKNESS_VISIBILITY("tweakDarknessVisibility", false, ""),
    TWEAK_ELYTRA_CAMERA("tweakElytraCamera", false, ""),
    TWEAK_ENTITY_REACH_OVERRIDE("tweakEntityReachOverride", false, true, ""),
    TWEAK_ENTITY_TYPE_ATTACK_RESTRICTION("tweakEntityTypeAttackRestriction", false, ""),
    TWEAK_SHULKERBOX_STACKING("tweakEmptyShulkerBoxesStack", false, true, ""),
    TWEAK_EXPLOSION_REDUCED_PARTICLES("tweakExplosionReducedParticles", false, ""),
    TWEAK_F3_CURSOR("tweakF3Cursor", false, ""),
    TWEAK_FAKE_SNEAKING("tweakFakeSneaking", false, ""),
    TWEAK_FAKE_SNEAK_PLACEMENT("tweakFakeSneakPlacement", false, ""),
    TWEAK_FAST_BLOCK_PLACEMENT("tweakFastBlockPlacement", false, ""),
    TWEAK_FAST_LEFT_CLICK("tweakFastLeftClick", false, ""),
    TWEAK_FAST_RIGHT_CLICK("tweakFastRightClick", false, ""),
    TWEAK_FILL_CLONE_LIMIT("tweakFillCloneLimit", false, true, ""),
    TWEAK_FLY_SPEED("tweakFlySpeed", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_FLEXIBLE_BLOCK_PLACEMENT("tweakFlexibleBlockPlacement", false, ""),
    TWEAK_FREE_CAMERA("tweakFreeCamera", false, ""),
    TWEAK_GAMMA_OVERRIDE("tweakGammaOverride", false, ""),
    TWEAK_HAND_RESTOCK("tweakHandRestock", false, ""),
    TWEAK_HANGABLE_ENTITY_BYPASS("tweakHangableEntityBypass", false, ""),
    TWEAK_HOLD_ATTACK("tweakHoldAttack", false, ""),
    TWEAK_HOLD_USE("tweakHoldUse", false, ""),
    TWEAK_HOTBAR_SCROLL("tweakHotbarScroll", false, ""),
    TWEAK_HOTBAR_SLOT_CYCLE("tweakHotbarSlotCycle", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_HOTBAR_SLOT_RANDOMIZER("tweakHotbarSlotRandomizer", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_HOTBAR_SWAP("tweakHotbarSwap", false, ""),
    TWEAK_INVENTORY_PREVIEW("tweakInventoryPreview", false, true, ""),
    TWEAK_ITEM_UNSTACKING_PROTECTION("tweakItemUnstackingProtection", false, ""),
    TWEAK_LAVA_VISIBILITY("tweakLavaVisibility", false, ""),
    TWEAK_MAP_PREVIEW("tweakMapPreview", false, ""),
    TWEAK_MATCHING_SKY_FOG("tweakMatchingSkyFog", false, ""),
    TWEAK_MOVEMENT_KEYS("tweakMovementKeysLast", false, ""),
    TWEAK_PERIODIC_ATTACK("tweakPeriodicAttack", false, ""),
    TWEAK_PERIODIC_USE("tweakPeriodicUse", false, ""),
    TWEAK_PERIODIC_HOLD_ATTACK("tweakPeriodicHoldAttack", false, ""),
    TWEAK_PERIODIC_HOLD_USE("tweakPeriodicHoldUse", false, ""),
    TWEAK_PERMANENT_SNEAK("tweakPermanentSneak", false, ""),
    TWEAK_PERMANENT_SPRINT("tweakPermanentSprint", false, ""),
    TWEAK_PLACEMENT_GRID("tweakPlacementGrid", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_PLACEMENT_LIMIT("tweakPlacementLimit", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_PLACEMENT_RESTRICTION("tweakPlacementRestriction", false, ""),
    TWEAK_PLACEMENT_REST_FIRST("tweakPlacementRestrictionFirst", false, ""),
    TWEAK_PLACEMENT_REST_HAND("tweakPlacementRestrictionHand", false, ""),
    TWEAK_PLAYER_INVENTORY_PEEK("tweakPlayerInventoryPeek", false, ""),
    TWEAK_POTION_WARNING("tweakPotionWarning", false, ""),
    TWEAK_PRINT_DEATH_COORDINATES("tweakPrintDeathCoordinates", false, ""),
    TWEAK_PICK_BEFORE_PLACE("tweakPickBeforePlace", false, ""),
    TWEAK_PLAYER_LIST_ALWAYS_ON("tweakPlayerListAlwaysVisible", false, ""),
    TWEAK_RENDER_EDGE_CHUNKS("tweakRenderEdgeChunks", false, ""),
    TWEAK_RENDER_INVISIBLE_ENTITIES("tweakRenderInvisibleEntities", false, ""),
    TWEAK_RENDER_LIMIT_ENTITIES("tweakRenderLimitEntities", false, ""),
    TWEAK_REPAIR_MODE("tweakRepairMode", false, ""),
    TWEAK_SCAFFOLD_PLACE("tweakScaffoldPlace", false, ""),
    TWEAK_SCULK_PULSE_LENGTH("tweakSculkPulseLength", false, true, ""),
    TWEAK_SELECTIVE_BLOCKS_RENDERING("tweakSelectiveBlocksRendering", false, ""),
    TWEAK_SELECTIVE_BLOCKS_RENDER_OUTLINE("tweakSelectiveBlocksRenderOutline", false, ""),
    TWEAK_SERVER_DATA_SYNC("tweakServerDataSync", false, ""),
    TWEAK_SERVER_DATA_SYNC_BACKUP("tweakServerDataSyncBackup", false, ""),
    TWEAK_SHULKERBOX_DISPLAY("tweakShulkerBoxDisplay", false, ""),
    TWEAK_SIGN_COPY("tweakSignCopy", false, ""),
    TWEAK_SNAP_AIM("tweakSnapAim", false, "", KeybindSettings.INGAME_BOTH),
    TWEAK_SNAP_AIM_LOCK("tweakSnapAimLock", false, ""),
    TWEAK_SNEAK_1_15_2("tweakSneak_1.15.2", false, "", "tweakeroo.config.feature_toggle.comment.tweakSneak_1_15_2", "tweakeroo.config.feature_toggle.prettyName.tweakSneak_1_15_2", "tweakeroo.config.feature_toggle.name.tweakSneak_1_15_2"),
    TWEAK_SPECTATOR_TELEPORT("tweakSpectatorTeleport", false, ""),
    TWEAK_STRUCTURE_BLOCK_LIMIT("tweakStructureBlockLimit", false, true, ""),
    TWEAK_SWAP_ALMOST_BROKEN_TOOLS("tweakSwapAlmostBrokenTools", false, ""),
    TWEAK_TAB_COMPLETE_COORDINATE("tweakTabCompleteCoordinate", false, ""),
    TWEAK_TOOL_SWITCH("tweakToolSwitch", false, ""),
    TWEAK_WATER_VISIBILITY("tweakWaterVisibility", false, ""),
    TWEAK_WEAPON_SWITCH("tweakWeaponSwitch", false, ""),
    TWEAK_Y_MIRROR("tweakYMirror", false, ""),
    TWEAK_ZOOM("tweakZoom", false, "", KeybindSettings.INGAME_BOTH);

    public static final ImmutableList<FeatureToggle> VALUES;
    private static final String FEATURE_KEY = "tweakeroo.config.feature_toggle";
    private final String name;
    private String comment;
    private String prettyName;
    private String translatedName;
    private final IKeybind keybind;
    private final boolean defaultValueBoolean;
    private final boolean singlePlayer;
    private boolean valueBoolean;
    private IValueChangeCallback<IConfigBoolean> callback;
    private boolean dirty = false;

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey) {
        this(name, defaultValue, false, defaultHotkey, KeybindSettings.DEFAULT, FeatureToggle.buildTranslateName(name, "comment"), FeatureToggle.buildTranslateName(name, "prettyName"), FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings) {
        this(name, defaultValue, false, defaultHotkey, settings, FeatureToggle.buildTranslateName(name, "comment"), FeatureToggle.buildTranslateName(name, "prettyName"), FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey) {
        this(name, defaultValue, singlePlayer, defaultHotkey, KeybindSettings.DEFAULT, FeatureToggle.buildTranslateName(name, "comment"), FeatureToggle.buildTranslateName(name, "prettyName"), FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, false, defaultHotkey, comment, prettyName, translatedName);
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, singlePlayer, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, translatedName);
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, String comment) {
        this(name, defaultValue, false, defaultHotkey, KeybindSettings.DEFAULT, comment, FeatureToggle.buildTranslateName(name, "prettyName"), FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, String comment) {
        this(name, defaultValue, singlePlayer, defaultHotkey, KeybindSettings.DEFAULT, comment, FeatureToggle.buildTranslateName(name, "prettyName"), FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings, String comment) {
        this(name, defaultValue, false, defaultHotkey, settings, comment, FeatureToggle.buildTranslateName(name, "prettyName"), FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, KeybindSettings settings, String comment) {
        this(name, defaultValue, singlePlayer, defaultHotkey, settings, comment, FeatureToggle.buildTranslateName(name, "prettyName"), FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, String comment, String prettyName) {
        this(name, defaultValue, false, defaultHotkey, comment, prettyName, FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, String comment, String prettyName) {
        this(name, defaultValue, singlePlayer, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, KeybindSettings settings, String comment, String prettyName) {
        this(name, defaultValue, singlePlayer, defaultHotkey, settings, comment, prettyName, FeatureToggle.buildTranslateName(name, "name"));
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, KeybindSettings settings, String comment, String prettyName, String translatedName) {
        this.name = name;
        this.valueBoolean = defaultValue;
        this.defaultValueBoolean = defaultValue;
        this.singlePlayer = singlePlayer;
        this.comment = comment;
        this.prettyName = prettyName;
        this.translatedName = translatedName;
        this.keybind = KeybindMulti.fromStorageString((String)defaultHotkey, (KeybindSettings)settings);
        this.keybind.setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)this));
    }

    public ConfigType getType() {
        return ConfigType.HOTKEY;
    }

    public String getName() {
        if (this.singlePlayer) {
            return GuiBase.TXT_GOLD + this.name + GuiBase.TXT_RST;
        }
        return this.name;
    }

    public String getConfigGuiDisplayName() {
        Object name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.singlePlayer) {
            name = GuiBase.TXT_GOLD + (String)name + GuiBase.TXT_RST;
        }
        return name;
    }

    public String getPrettyName() {
        return StringUtils.getTranslatedOrFallback((String)this.prettyName, (String)(!this.prettyName.isEmpty() ? this.prettyName : StringUtils.splitCamelCase((String)this.name.substring(5))));
    }

    public String getTranslatedName() {
        Object name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.singlePlayer) {
            name = GuiBase.TXT_GOLD + (String)name + GuiBase.TXT_RST;
        }
        return name;
    }

    public String getComment() {
        String comment = StringUtils.getTranslatedOrFallback((String)this.comment, (String)this.comment);
        if (comment != null && this.singlePlayer) {
            return comment + "\n" + StringUtils.translate((String)"tweakeroo.label.config_comment.single_player_only", (Object[])new Object[0]);
        }
        return comment;
    }

    public void setPrettyName(String s) {
        this.prettyName = s;
    }

    public void setTranslatedName(String s) {
        this.translatedName = s;
    }

    public void setComment(String s) {
        this.comment = s;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void checkIfClean() {
        if (this.isDirty()) {
            this.markClean();
            this.onValueChanged();
        }
    }

    private static String buildTranslateName(String name, String type) {
        return "tweakeroo.config.feature_toggle." + type + "." + name;
    }

    public String getStringValue() {
        return String.valueOf(this.valueBoolean);
    }

    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValueBoolean);
    }

    public void setValueFromString(String value) {
    }

    public void onValueChanged() {
        if (this.callback != null) {
            this.callback.onValueChanged((IConfigBase)this);
        }
    }

    public void setValueChangeCallback(IValueChangeCallback<IConfigBoolean> callback) {
        this.callback = callback;
    }

    public IKeybind getKeybind() {
        return this.keybind;
    }

    public boolean getBooleanValue() {
        return this.valueBoolean;
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultValueBoolean;
    }

    public void setBooleanValue(boolean value) {
        boolean oldValue = this.valueBoolean;
        this.valueBoolean = value;
        if (oldValue != this.valueBoolean) {
            this.onValueChanged();
        }
    }

    public void setEnabledNoCallback() {
        if (!this.valueBoolean) {
            this.valueBoolean = true;
        }
    }

    public boolean isModified() {
        return this.valueBoolean != this.defaultValueBoolean;
    }

    public boolean isModified(String newValue) {
        return Boolean.parseBoolean(newValue) != this.defaultValueBoolean;
    }

    public void resetToDefault() {
        boolean oldValue = this.valueBoolean;
        this.valueBoolean = this.defaultValueBoolean;
        if (oldValue != this.valueBoolean) {
            this.onValueChanged();
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.valueBoolean));
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.setBooleanValue(element.getAsBoolean());
            } else {
                Tweakeroo.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            Tweakeroo.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])FeatureToggle.values());
    }
}

