/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Size;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NinePatchTexture {
    private final class_2960 texture;
    private final int u;
    private final int v;
    private final PatchSizing patchSizing;
    private final Size textureSize;
    private final boolean repeat;
    public static final Endec<NinePatchTexture> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("texture", texture -> texture.texture), (StructField)Endec.INT.optionalFieldOf("u", texture -> texture.u, (Object)0), (StructField)Endec.INT.optionalFieldOf("v", texture -> texture.v, (Object)0), (StructField)PatchSizing.ENDEC.flatFieldOf(texture -> texture.patchSizing), (StructField)StructEndecBuilder.of((StructField)Endec.INT.fieldOf("texture_width", Size::width), (StructField)Endec.INT.fieldOf("texture_height", Size::height), Size::of).flatFieldOf(texture -> texture.textureSize), (StructField)Endec.BOOLEAN.fieldOf("repeat", texture -> texture.repeat), NinePatchTexture::new);

    public NinePatchTexture(class_2960 texture, int u, int v, PatchSizing patchSizing, Size textureSize, boolean repeat) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.textureSize = textureSize;
        this.patchSizing = patchSizing;
        this.repeat = repeat;
    }

    public NinePatchTexture(class_2960 texture, int u, int v, Size cornerPatchSize, Size centerPatchSize, Size textureSize, boolean repeat) {
        this(texture, u, v, new PatchSizing(null, cornerPatchSize, centerPatchSize), textureSize, repeat);
    }

    public NinePatchTexture(class_2960 texture, int u, int v, Size patchSize, Size textureSize, boolean repeat) {
        this(texture, u, v, new PatchSizing(patchSize, null, null), textureSize, repeat);
    }

    private Size cornerPatchSize() {
        return this.patchSizing.cornerPatchSize();
    }

    private Size centerPatchSize() {
        return this.patchSizing.centerPatchSize();
    }

    public void draw(OwoUIDrawContext context, PositionedRectangle rectangle) {
        this.draw(context, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height());
    }

    public void draw(OwoUIDrawContext context, int x, int y, int width, int height) {
        this.draw(context, class_10799.field_56883, x, y, width, height);
    }

    public void draw(OwoUIDrawContext context, RenderPipeline pipeline, int x, int y, int width, int height) {
        int rightEdge = this.cornerPatchSize().width() + this.centerPatchSize().width();
        int bottomEdge = this.cornerPatchSize().height() + this.centerPatchSize().height();
        context.method_25290(pipeline, this.texture, x, y, this.u, this.v, this.cornerPatchSize().width(), this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
        context.method_25290(pipeline, this.texture, x + width - this.cornerPatchSize().width(), y, this.u + rightEdge, this.v, this.cornerPatchSize().width(), this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
        context.method_25290(pipeline, this.texture, x, y + height - this.cornerPatchSize().height(), this.u, this.v + bottomEdge, this.cornerPatchSize().width(), this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
        context.method_25290(pipeline, this.texture, x + width - this.cornerPatchSize().width(), y + height - this.cornerPatchSize().height(), this.u + rightEdge, this.v + bottomEdge, this.cornerPatchSize().width(), this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
        if (this.repeat) {
            this.drawRepeated(context, pipeline, x, y, width, height);
        } else {
            this.drawStretched(context, pipeline, x, y, width, height);
        }
    }

    protected void drawStretched(OwoUIDrawContext context, RenderPipeline pipeline, int x, int y, int width, int height) {
        int doubleCornerHeight = this.cornerPatchSize().height() * 2;
        int doubleCornerWidth = this.cornerPatchSize().width() * 2;
        int rightEdge = this.cornerPatchSize().width() + this.centerPatchSize().width();
        int bottomEdge = this.cornerPatchSize().height() + this.centerPatchSize().height();
        if (width > doubleCornerWidth && height > doubleCornerHeight) {
            context.method_25302(pipeline, this.texture, x + this.cornerPatchSize().width(), y + this.cornerPatchSize().height(), this.u + this.cornerPatchSize().width(), this.v + this.cornerPatchSize().height(), width - doubleCornerWidth, height - doubleCornerHeight, this.centerPatchSize().width(), this.centerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
        }
        if (width > doubleCornerWidth) {
            context.method_25302(pipeline, this.texture, x + this.cornerPatchSize().width(), y, this.u + this.cornerPatchSize().width(), this.v, width - doubleCornerWidth, this.cornerPatchSize().height(), this.centerPatchSize().width(), this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
            context.method_25302(pipeline, this.texture, x + this.cornerPatchSize().width(), y + height - this.cornerPatchSize().height(), this.u + this.cornerPatchSize().width(), this.v + bottomEdge, width - doubleCornerWidth, this.cornerPatchSize().height(), this.centerPatchSize().width(), this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
        }
        if (height > doubleCornerHeight) {
            context.method_25302(pipeline, this.texture, x, y + this.cornerPatchSize().height(), this.u, this.v + this.cornerPatchSize().height(), this.cornerPatchSize().width(), height - doubleCornerHeight, this.cornerPatchSize().width(), this.centerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
            context.method_25302(pipeline, this.texture, x + width - this.cornerPatchSize().width(), y + this.cornerPatchSize().height(), this.u + rightEdge, this.v + this.cornerPatchSize().height(), this.cornerPatchSize().width(), height - doubleCornerHeight, this.cornerPatchSize().width(), this.centerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
        }
    }

    protected void drawRepeated(OwoUIDrawContext context, RenderPipeline pipeline, int x, int y, int width, int height) {
        int drawHeight;
        int leftoverHeight;
        int doubleCornerHeight = this.cornerPatchSize().height() * 2;
        int doubleCornerWidth = this.cornerPatchSize().width() * 2;
        int rightEdge = this.cornerPatchSize().width() + this.centerPatchSize().width();
        int bottomEdge = this.cornerPatchSize().height() + this.centerPatchSize().height();
        if (width > doubleCornerWidth && height > doubleCornerHeight) {
            for (leftoverHeight = height - doubleCornerHeight; leftoverHeight > 0; leftoverHeight -= this.centerPatchSize().height()) {
                drawHeight = Math.min(this.centerPatchSize().height(), leftoverHeight);
                for (int leftoverWidth = width - doubleCornerWidth; leftoverWidth > 0; leftoverWidth -= this.centerPatchSize().width()) {
                    int drawWidth = Math.min(this.centerPatchSize().width(), leftoverWidth);
                    context.method_25302(pipeline, this.texture, x + this.cornerPatchSize().width() + leftoverWidth - drawWidth, y + this.cornerPatchSize().height() + leftoverHeight - drawHeight, this.u + this.cornerPatchSize().width() + this.centerPatchSize().width() - drawWidth, this.v + this.cornerPatchSize().height() + this.centerPatchSize().height() - drawHeight, drawWidth, drawHeight, drawWidth, drawHeight, this.textureSize.width(), this.textureSize.height());
                }
            }
        }
        if (width > doubleCornerWidth) {
            for (int leftoverWidth = width - doubleCornerWidth; leftoverWidth > 0; leftoverWidth -= this.centerPatchSize().width()) {
                int drawWidth = Math.min(this.centerPatchSize().width(), leftoverWidth);
                context.method_25302(pipeline, this.texture, x + this.cornerPatchSize().width() + leftoverWidth - drawWidth, y, this.u + this.cornerPatchSize().width() + this.centerPatchSize().width() - drawWidth, this.v, drawWidth, this.cornerPatchSize().height(), drawWidth, this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
                context.method_25302(pipeline, this.texture, x + this.cornerPatchSize().width() + leftoverWidth - drawWidth, y + height - this.cornerPatchSize().height(), this.u + this.cornerPatchSize().width() + this.centerPatchSize().width() - drawWidth, this.v + bottomEdge, drawWidth, this.cornerPatchSize().height(), drawWidth, this.cornerPatchSize().height(), this.textureSize.width(), this.textureSize.height());
            }
        }
        if (height > doubleCornerHeight) {
            for (leftoverHeight = height - doubleCornerHeight; leftoverHeight > 0; leftoverHeight -= this.centerPatchSize().height()) {
                drawHeight = Math.min(this.centerPatchSize().height(), leftoverHeight);
                context.method_25302(pipeline, this.texture, x, y + this.cornerPatchSize().height() + leftoverHeight - drawHeight, this.u, this.v + this.cornerPatchSize().height() + this.centerPatchSize().height() - drawHeight, this.cornerPatchSize().width(), drawHeight, this.cornerPatchSize().width(), drawHeight, this.textureSize.width(), this.textureSize.height());
                context.method_25302(pipeline, this.texture, x + width - this.cornerPatchSize().width(), y + this.cornerPatchSize().height() + leftoverHeight - drawHeight, this.u + rightEdge, this.v + this.cornerPatchSize().height() + this.centerPatchSize().height() - drawHeight, this.cornerPatchSize().width(), drawHeight, this.cornerPatchSize().width(), drawHeight, this.textureSize.width(), this.textureSize.height());
            }
        }
    }

    public static void draw(class_2960 texture, OwoUIDrawContext context, int x, int y, int width, int height) {
        NinePatchTexture.draw(texture, context, class_10799.field_56883, x, y, width, height);
    }

    public static void draw(class_2960 texture, OwoUIDrawContext context, RenderPipeline pipeline, int x, int y, int width, int height) {
        NinePatchTexture.ifPresent(texture, ninePatchTexture -> ninePatchTexture.draw(context, pipeline, x, y, width, height));
    }

    public static void draw(class_2960 texture, OwoUIDrawContext context, PositionedRectangle rectangle) {
        NinePatchTexture.ifPresent(texture, ninePatchTexture -> ninePatchTexture.draw(context, rectangle));
    }

    private static void ifPresent(class_2960 texture, Consumer<NinePatchTexture> action) {
        if (!MetadataLoader.LOADED_TEXTURES.containsKey(texture)) {
            return;
        }
        action.accept(MetadataLoader.LOADED_TEXTURES.get(texture));
    }

    public record PatchSizing(@Nullable Size patchSize, @Nullable Size cornerPatchSize, @Nullable Size centerPatchSize) {
        @Nullable
        private final Size cornerPatchSize;
        @Nullable
        private final Size centerPatchSize;
        public static final StructEndec<PatchSizing> ENDEC = StructEndecBuilder.of((StructField)Size.ENDEC.nullableOf().optionalFieldOf("patch_size", PatchSizing::patchSize, () -> null), (StructField)Size.ENDEC.nullableOf().optionalFieldOf("corner_patch_size", PatchSizing::cornerPatchSize, () -> null), (StructField)Size.ENDEC.nullableOf().optionalFieldOf("center_patch_size", PatchSizing::centerPatchSize, () -> null), PatchSizing::new);

        public PatchSizing(@Nullable Size patchSize, @Nullable Size cornerPatchSize, @Nullable Size centerPatchSize) {
            if (patchSize == null) {
                if (cornerPatchSize != null && centerPatchSize == null) {
                    throw new IllegalStateException("Missing center Patch Size while providing corner Patch Size!");
                }
                if (cornerPatchSize == null && centerPatchSize != null) {
                    throw new IllegalStateException("Missing corner Patch Size while providing center Patch Size!");
                }
                if (cornerPatchSize == null && centerPatchSize == null) {
                    throw new IllegalStateException("Missing base patch Size or patch size for both corner and center!");
                }
            }
        }

        @NotNull
        public Size cornerPatchSize() {
            return this.cornerPatchSize != null ? this.cornerPatchSize : this.patchSize;
        }

        @NotNull
        public Size centerPatchSize() {
            return this.centerPatchSize != null ? this.centerPatchSize : this.patchSize;
        }
    }

    public static class MetadataLoader
    extends class_4309<NinePatchTexture>
    implements IdentifiableResourceReloadListener {
        private static final Map<class_2960, NinePatchTexture> LOADED_TEXTURES = new HashMap<class_2960, NinePatchTexture>();

        public MetadataLoader() {
            super(CodecUtils.toCodec(ENDEC), class_7654.method_45114((String)"nine_patch_textures"));
        }

        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"owo", (String)"nine_patch_metadata");
        }

        protected void apply(Map<class_2960, NinePatchTexture> prepared, class_3300 manager, class_3695 profiler) {
            LOADED_TEXTURES.putAll(prepared);
        }
    }
}

