/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.codecs.EnumCodec;
import mezz.jei.common.config.file.JsonArrayFileHelper;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.BookmarkType;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.config.IBookmarkConfig;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BookmarkJsonConfig
implements IBookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int VERSION = 3;
    private static final Codec<BookmarkType> TYPE_CODEC = EnumCodec.create(BookmarkType.class);
    @Nullable
    private static MapCodec<IBookmark> BOOKMARK_CODEC;
    private final Path jeiConfigurationDir;

    private static MapCodec<IBookmark> getBookmarkCodec(ICodecHelper codecHelper, IIngredientManager ingredientManager, IRecipeManager recipeManager) {
        if (BOOKMARK_CODEC == null) {
            BOOKMARK_CODEC = TYPE_CODEC.dispatchMap("bookmarkType", IBookmark::getType, type -> type.getCodec(codecHelper, ingredientManager, recipeManager));
        }
        return BOOKMARK_CODEC;
    }

    private static Optional<Path> getPath(Path jeiConfigurationDir) {
        return ServerConfigPathUtil.getWorldPath(jeiConfigurationDir).flatMap(configPath -> {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create bookmark config folder: {}", configPath, (Object)e);
                return Optional.empty();
            }
            Path path = configPath.resolve("bookmarks.json");
            return Optional.of(path);
        });
    }

    public BookmarkJsonConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    private class_6903<JsonElement> getRegistryOps(class_5455 registryAccess) {
        return registryAccess.method_57093((DynamicOps)JsonOps.INSTANCE);
    }

    @Override
    public boolean saveBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, class_5455 registryAccess, ICodecHelper codecHelper, List<IBookmark> bookmarks) {
        return BookmarkJsonConfig.getPath(this.jeiConfigurationDir).map(path -> {
            Boolean bl;
            block8: {
                Codec bookmarkCodec = BookmarkJsonConfig.getBookmarkCodec(codecHelper, ingredientManager, recipeManager).codec();
                class_6903<JsonElement> registryOps = this.getRegistryOps(registryAccess);
                BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);
                try {
                    JsonArrayFileHelper.write(out, 3, bookmarks, bookmarkCodec, registryOps, error -> LOGGER.error("Encountered an error when saving the bookmarks config to file {}\n{}", path, error), (element, exception) -> LOGGER.error("Encountered an exception when saving the bookmarks config to file {}\n{}", path, element, exception));
                    LOGGER.debug("Saved bookmarks config to file: {}", path);
                    bl = true;
                    if (out == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to save bookmarks config to file {}", path, (Object)e);
                        return false;
                    }
                }
                out.close();
            }
            return bl;
        }).orElse(false);
    }

    @Override
    public void loadBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, class_5455 registryAccess, BookmarkList bookmarkList, ICodecHelper codecHelper) {
        class_6903<JsonElement> registryOps = this.getRegistryOps(registryAccess);
        List<IBookmark> bookmarks = this.loadJsonBookmarks(ingredientManager, recipeManager, registryOps, codecHelper);
        bookmarkList.setFromConfigFile(bookmarks);
    }

    private @Unmodifiable List<IBookmark> loadJsonBookmarks(IIngredientManager ingredientManager, IRecipeManager recipeManager, class_6903<JsonElement> registryOps, ICodecHelper codecHelper) {
        return BookmarkJsonConfig.getPath(this.jeiConfigurationDir).map(path -> {
            List<Object> bookmarks;
            if (!Files.exists(path, new LinkOption[0])) {
                return List.of();
            }
            Codec bookmarkCodec = BookmarkJsonConfig.getBookmarkCodec(codecHelper, ingredientManager, recipeManager).codec();
            try (BufferedReader reader = Files.newBufferedReader(path);){
                bookmarks = JsonArrayFileHelper.read(reader, 3, bookmarkCodec, (DynamicOps<JsonElement>)registryOps, (element, error) -> LOGGER.error("Encountered an error when loading the bookmark config from file {}\n{}\n{}", path, element, error), (element, exception) -> LOGGER.error("Encountered an exception when loading the bookmark config from file {}\n{}", path, element, exception));
                LOGGER.debug("Loaded bookmarks config from file: {}", path);
            }
            catch (IOException | RuntimeException e) {
                LOGGER.error("Failed to load bookmarks from file {}", path, (Object)e);
                bookmarks = new ArrayList();
            }
            return bookmarks;
        }).orElseGet(List::of);
    }
}

