/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.util.position.BlockRotation;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4050;

public class PositionUtils {
    public static final class_2350[] ALL_DIRECTIONS = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    public static final class_2350[] HORIZONTAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    public static final class_2350[] VERTICAL_DIRECTIONS = new class_2350[]{class_2350.field_11033, class_2350.field_11036};
    public static final int SIZE_BITS_X = 26;
    public static final int SIZE_BITS_Z = 26;
    public static final int SIZE_BITS_Y = 12;
    public static final long BITMASK_X = 0x3FFFFFFL;
    public static final long BITMASK_Y = 4095L;
    public static final long BITMASK_Z = 0x3FFFFFFL;
    public static final int BIT_SHIFT_Z = 0;
    public static final int BIT_SHIFT_Y = 26;
    public static final int BIT_SHIFT_X = 38;

    public static long blockPosToLong(int x, int y, int z) {
        return ((long)x & 0x3FFFFFFL) << 38 | ((long)y & 0xFFFL) << 26 | ((long)z & 0x3FFFFFFL) << 0;
    }

    public static int unpackX(long packedPos) {
        return (int)(packedPos << 0 >> 38);
    }

    public static int unpackY(long packedPos) {
        return (int)(packedPos << 26 >> 52);
    }

    public static int unpackZ(long packedPos) {
        return (int)(packedPos << 38 >> 38);
    }

    public static int getPackedChunkRelativePosition(class_2338 pos) {
        return pos.method_10264() << 8 | (pos.method_10260() & 0xF) << 4 | pos.method_10263() & 0xF;
    }

    public static long getPackedAbsolutePosition(long chunkPos, int chunkRelativeBlockPos) {
        int chunkX = (int)chunkPos;
        int chunkZ = (int)(chunkPos >> 32);
        int x = (chunkX << 4) + (chunkRelativeBlockPos & 0xF);
        int y = chunkRelativeBlockPos >> 8;
        int z = (chunkZ << 4) + (chunkRelativeBlockPos >> 4 & 0xF);
        return PositionUtils.blockPosToLong(x, y, z);
    }

    public static int getChunkPosX(long chunkPosLong) {
        return (int)chunkPosLong;
    }

    public static int getChunkPosZ(long chunkPosLong) {
        return (int)(chunkPosLong >> 32);
    }

    public static class_1923 chunkPosFromLong(long chunkPosLong) {
        return new class_1923(PositionUtils.getChunkPosX(chunkPosLong), PositionUtils.getChunkPosZ(chunkPosLong));
    }

    public static class_2338 getMinCorner(class_2338 pos1, class_2338 pos2) {
        return new class_2338(Math.min(pos1.method_10263(), pos2.method_10263()), Math.min(pos1.method_10264(), pos2.method_10264()), Math.min(pos1.method_10260(), pos2.method_10260()));
    }

    public static class_2338 getMinCorner(class_2338 pos1, class_2338 pos2, class_2338 pos3) {
        return new class_2338(Math.min(pos1.method_10263(), Math.min(pos2.method_10263(), pos3.method_10263())), Math.min(pos1.method_10264(), Math.min(pos2.method_10264(), pos3.method_10264())), Math.min(pos1.method_10260(), Math.min(pos2.method_10260(), pos3.method_10260())));
    }

    public static class_2338 getMaxCorner(class_2338 pos1, class_2338 pos2) {
        return new class_2338(Math.max(pos1.method_10263(), pos2.method_10263()), Math.max(pos1.method_10264(), pos2.method_10264()), Math.max(pos1.method_10260(), pos2.method_10260()));
    }

    public static class_2338 getMaxCorner(class_2338 pos1, class_2338 pos2, class_2338 pos3) {
        return new class_2338(Math.max(pos1.method_10263(), Math.max(pos2.method_10263(), pos3.method_10263())), Math.max(pos1.method_10264(), Math.max(pos2.method_10264(), pos3.method_10264())), Math.max(pos1.method_10260(), Math.max(pos2.method_10260(), pos3.method_10260())));
    }

    public static boolean isPositionInsideArea(class_2338 pos, class_2338 posMin, class_2338 posMax) {
        return pos.method_10263() >= posMin.method_10263() && pos.method_10263() <= posMax.method_10263() && pos.method_10264() >= posMin.method_10264() && pos.method_10264() <= posMax.method_10264() && pos.method_10260() >= posMin.method_10260() && pos.method_10260() <= posMax.method_10260();
    }

    public static class_2350 getClosestSideDirection(class_1297 entity) {
        float forwardYaw;
        class_2350 forwardDirection = entity.method_5735();
        float entityYaw = (entity.method_36454() % 360.0f + 360.0f) % 360.0f;
        if (entityYaw < (forwardYaw = forwardDirection.method_10144()) || forwardYaw == 0.0f && entityYaw > 270.0f) {
            return forwardDirection.method_10160();
        }
        return forwardDirection.method_10170();
    }

    public static class_2338 getPositionInFrontOfEntity(class_1297 entity) {
        return PositionUtils.getPositionInFrontOfEntity(entity, 60.0f);
    }

    public static class_2338 getPositionInFrontOfEntity(class_1297 entity, float verticalThreshold) {
        double x = entity.method_23317();
        double y = entity.method_23318();
        double z = entity.method_23321();
        float pitch = entity.method_36455();
        if (pitch >= verticalThreshold) {
            return class_2338.method_49637((double)x, (double)(y - 1.0), (double)z);
        }
        if (pitch <= -verticalThreshold) {
            return class_2338.method_49637((double)x, (double)Math.ceil(entity.method_5829().field_1325), (double)z);
        }
        double width = entity.method_17681();
        y = Math.floor(y + (double)entity.method_18381(class_4050.field_18076));
        return switch (entity.method_5735()) {
            case class_2350.field_11034 -> new class_2338((int)Math.ceil(x + width / 2.0), (int)y, (int)Math.floor(z));
            case class_2350.field_11039 -> new class_2338((int)Math.floor(x - width / 2.0) - 1, (int)y, (int)Math.floor(z));
            case class_2350.field_11035 -> new class_2338((int)Math.floor(x), (int)y, (int)Math.ceil(z + width / 2.0));
            case class_2350.field_11043 -> new class_2338((int)Math.floor(x), (int)y, (int)Math.floor(z - width / 2.0) - 1);
            default -> class_2338.method_49637((double)x, (double)y, (double)z);
        };
    }

    @Nullable
    public static BlockRotation getRotation(class_2350 directionFrom, class_2350 directionTo) {
        if (directionFrom == directionTo) {
            return BlockRotation.NONE;
        }
        if (directionFrom.method_10166() == class_2350.class_2351.field_11052 || directionTo.method_10166() == class_2350.class_2351.field_11052) {
            return null;
        }
        if (directionTo == directionFrom.method_10153()) {
            return BlockRotation.CW_180;
        }
        return directionTo == directionFrom.method_10170() ? BlockRotation.CW_90 : BlockRotation.CCW_90;
    }

    public static class_243 getHitVecCenter(class_2338 basePos, class_2350 facing) {
        int x = basePos.method_10263();
        int y = basePos.method_10264();
        int z = basePos.method_10260();
        return switch (facing) {
            case class_2350.field_11036 -> new class_243((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            case class_2350.field_11033 -> new class_243((double)x + 0.5, (double)y, (double)z + 0.5);
            case class_2350.field_11043 -> new class_243((double)x + 0.5, (double)y + 0.5, (double)z);
            case class_2350.field_11035 -> new class_243((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            case class_2350.field_11039 -> new class_243((double)x, (double)y + 0.5, (double)z);
            case class_2350.field_11034 -> new class_243((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            default -> new class_243((double)x, (double)y, (double)z);
        };
    }

    public static HitPart getHitPart(class_2350 originalSide, class_2350 playerFacingH, class_2338 pos, class_243 hitVec) {
        class_243 positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.field_1352;
        double posV = positions.field_1351;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static class_243 getHitPartPositions(class_2350 originalSide, class_2350 playerFacingH, class_2338 pos, class_243 hitVec) {
        double x = hitVec.field_1352 - (double)pos.method_10263();
        double y = hitVec.field_1351 - (double)pos.method_10264();
        double z = hitVec.field_1350 - (double)pos.method_10260();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case field_11036: 
            case field_11033: {
                switch (playerFacingH) {
                    case field_11043: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case field_11035: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case field_11039: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case field_11034: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != class_2350.field_11033) break;
                posV = 1.0 - posV;
                break;
            }
            case field_11035: 
            case field_11043: {
                posH = originalSide.method_10171() == class_2350.class_2352.field_11056 ? x : 1.0 - x;
                posV = y;
                break;
            }
            case field_11034: 
            case field_11039: {
                posH = originalSide.method_10171() == class_2350.class_2352.field_11060 ? z : 1.0 - z;
                posV = y;
            }
        }
        return new class_243(posH, posV, 0.0);
    }

    public static class_2350 getTargetedDirection(class_2350 side, class_2350 playerFacingH, class_2338 pos, class_243 hitVec) {
        class_243 positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.field_1352;
        double posV = positions.field_1351;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.method_10166() == class_2350.class_2351.field_11052) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.method_10160() : playerFacingH.method_10170();
                }
                if (side == class_2350.field_11033) {
                    return posV > 0.5 ? playerFacingH.method_10153() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.method_10153() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.method_10170() : side.method_10160();
            }
            return posV < 0.5 ? class_2350.field_11033 : class_2350.field_11036;
        }
        return side;
    }

    public static class_243 adjustPositionToSideOfEntity(class_243 pos, class_1297 entity, class_2350 side) {
        double x = pos.field_1352;
        double y = pos.field_1351;
        double z = pos.field_1350;
        if (side == class_2350.field_11033) {
            y -= (double)entity.method_17682();
        } else if (side.method_10166().method_10179()) {
            x += (double)side.method_10148() * ((double)(entity.method_17681() / 2.0f) + 1.0E-4);
            z += (double)side.method_10165() * ((double)(entity.method_17681() / 2.0f) + 1.0E-4);
        }
        return new class_243(x, y, z);
    }

    public static class_243 modifyValue(CoordinateType type, class_243 valueIn, double amount) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new class_243(valueIn.field_1352 + amount, valueIn.field_1351, valueIn.field_1350);
            case 1 -> new class_243(valueIn.field_1352, valueIn.field_1351 + amount, valueIn.field_1350);
            case 2 -> new class_243(valueIn.field_1352, valueIn.field_1351, valueIn.field_1350 + amount);
        };
    }

    public static class_2338 modifyValue(CoordinateType type, class_2338 valueIn, int amount) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_2338.method_49637((double)(valueIn.method_10263() + amount), (double)valueIn.method_10264(), (double)valueIn.method_10260());
            case 1 -> class_2338.method_49637((double)valueIn.method_10263(), (double)(valueIn.method_10264() + amount), (double)valueIn.method_10260());
            case 2 -> class_2338.method_49637((double)valueIn.method_10263(), (double)valueIn.method_10264(), (double)(valueIn.method_10260() + amount));
        };
    }

    public static class_243 setValue(CoordinateType type, class_243 valueIn, double newValue) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new class_243(newValue, valueIn.field_1351, valueIn.field_1350);
            case 1 -> new class_243(valueIn.field_1352, newValue, valueIn.field_1350);
            case 2 -> new class_243(valueIn.field_1352, valueIn.field_1351, newValue);
        };
    }

    public static class_2338 setValue(CoordinateType type, class_2338 valueIn, int newValue) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_2338.method_49637((double)newValue, (double)valueIn.method_10264(), (double)valueIn.method_10260());
            case 1 -> class_2338.method_49637((double)valueIn.method_10263(), (double)newValue, (double)valueIn.method_10260());
            case 2 -> class_2338.method_49637((double)valueIn.method_10263(), (double)valueIn.method_10264(), (double)newValue);
        };
    }

    @Deprecated
    public static class_2350 getClosestLookingDirection(class_1297 entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    @Deprecated
    public static class_2350 getClosestLookingDirection(class_1297 entity, float verticalThreshold) {
        if (entity.method_36455() >= verticalThreshold) {
            return class_2350.field_11033;
        }
        if (entity.method_36454() <= -verticalThreshold) {
            return class_2350.field_11036;
        }
        return entity.method_5735();
    }

    public static class_2338 getEntityBlockPos(class_1297 entity) {
        return class_2338.method_49637((double)Math.floor(entity.method_23317()), (double)Math.floor(entity.method_23318()), (double)Math.floor(entity.method_23321()));
    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }
}

