/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.position.BlockRotation;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public enum BlockMirror implements IConfigOptionListEntry,
class_3542
{
    NONE(0, "none", null, class_2415.field_11302),
    X(1, "x", class_2350.class_2351.field_11048, class_2415.field_11301),
    Y(2, "y", class_2350.class_2351.field_11052, class_2415.field_11302),
    Z(3, "z", class_2350.class_2351.field_11051, class_2415.field_11300);

    public static final class_3542.class_7292<BlockMirror> CODEC;
    public static final IntFunction<BlockMirror> INDEX_TO_VALUE;
    public static final class_9139<ByteBuf, BlockMirror> PACKET_CODEC;
    public static final BlockMirror[] VALUES;
    private final int index;
    private final String name;
    private final String translationKey;
    private final class_2415 vanillaMirror;
    @Nullable
    private final class_2350.class_2351 axis;

    private BlockMirror(@Nullable int index, String name, class_2350.class_2351 axis, class_2415 vanillaMirror) {
        this.index = index;
        this.name = name;
        this.vanillaMirror = vanillaMirror;
        this.translationKey = "malilib.label.block_mirror." + name;
        this.axis = axis;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getStringValue() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Nonnull
    public String method_15434() {
        return this.name;
    }

    public BlockRotation toRotation(class_2350 direction) {
        if (direction.method_10166() == this.axis) {
            return BlockRotation.CW_180;
        }
        return BlockRotation.NONE;
    }

    public class_2350 mirror(class_2350 direction) {
        if (direction.method_10166() == this.axis) {
            return direction.method_10153();
        }
        return direction;
    }

    @Override
    public BlockMirror cycle(boolean reverse) {
        int index = this.index + (reverse ? -1 : 1) & 3;
        return VALUES[index];
    }

    @Override
    public IConfigOptionListEntry fromString(String value) {
        return BlockMirror.byName(value);
    }

    public class_2415 getVanillaMirror() {
        return this.vanillaMirror;
    }

    public static BlockMirror byName(String name) {
        for (BlockMirror mirror : VALUES) {
            if (!mirror.name.equalsIgnoreCase(name)) continue;
            return mirror;
        }
        return NONE;
    }

    static {
        CODEC = class_3542.method_28140(BlockMirror::values);
        INDEX_TO_VALUE = class_7995.method_47914(BlockMirror::getIndex, (Object[])BlockMirror.values(), (class_7995.class_7996)class_7995.class_7996.field_41665);
        PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, BlockMirror::getIndex);
        VALUES = BlockMirror.values();
    }
}

