/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test.gui;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.ICoordinateValueModifier;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class GuiTestPosEditor
extends GuiBase {
    private final TestVec3dSupplier vec3dSupplier;
    private final TestBlockPosSupplier blockPosSupplier;

    public GuiTestPosEditor() {
        this.title = StringUtils.translate("malilib.gui.title.test_pos_editor", new Object[0]);
        this.vec3dSupplier = new TestVec3dSupplier();
        this.blockPosSupplier = new TestBlockPosSupplier();
    }

    @Override
    public void initGui() {
        super.initGui();
        int x = 10;
        int y = 20;
        this.createPosEditorElements(x, y);
    }

    private void createPosEditorElements(int x, int y) {
        y += 12;
        GuiUtils.createVec3dInputsVertical(x, y, 120, this.vec3dSupplier.get(), new TestVec3dEditor(this.vec3dSupplier::get, this.vec3dSupplier::set, this), true, this);
        x += 180;
        GuiUtils.createBlockPosInputsVertical(x, y, 120, this.blockPosSupplier.get(), new TestBlockPosEditor(this.blockPosSupplier::get, this.blockPosSupplier::set, this), true, this);
    }

    public static class TestVec3dSupplier {
        private class_243 pos = class_243.field_1353;

        public class_243 get() {
            return this.pos;
        }

        public void set(class_243 pos) {
            this.pos = pos;
            this.debug();
        }

        public void debug() {
            MaLiLib.LOGGER.warn("TestVec3dSupplier: [{}]", (Object)this.get().toString());
        }
    }

    public static class TestBlockPosSupplier {
        private class_2338 pos = class_2338.field_10980;

        public class_2338 get() {
            return this.pos;
        }

        public void set(class_2338 pos) {
            this.pos = pos;
            this.debug();
        }

        public void debug() {
            MaLiLib.LOGGER.warn("TestBlockPosSupplier: [{}]", (Object)this.get().toString());
        }
    }

    public record TestVec3dEditor(Supplier<class_243> supplier, Consumer<class_243> consumer, GuiTestPosEditor gui) implements ICoordinateValueModifier
    {
        @Override
        public boolean modifyValue(PositionUtils.CoordinateType type, int amount) {
            this.consumer.accept(PositionUtils.modifyValue(type, this.supplier.get(), (double)amount));
            this.gui.initGui();
            return true;
        }

        @Override
        public boolean setValueFromString(PositionUtils.CoordinateType type, String newValue) {
            try {
                this.consumer.accept(PositionUtils.setValue(type, this.supplier.get(), Double.parseDouble(newValue)));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public record TestBlockPosEditor(Supplier<class_2338> supplier, Consumer<class_2338> consumer, GuiTestPosEditor gui) implements ICoordinateValueModifier
    {
        @Override
        public boolean modifyValue(PositionUtils.CoordinateType type, int amount) {
            this.consumer.accept(PositionUtils.modifyValue(type, this.supplier.get(), amount));
            this.gui.initGui();
            return true;
        }

        @Override
        public boolean setValueFromString(PositionUtils.CoordinateType type, String newValue) {
            try {
                this.consumer.accept(PositionUtils.setValue(type, this.supplier.get(), Integer.parseInt(newValue)));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

