/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import net.minecraft.class_327;

public class GuiTextFieldDouble
extends GuiTextFieldGeneric {
    private static final Pattern PATTERN_NUMBER = Pattern.compile("[-+]?([0-9]*[.])?[0-9]+([eE][-+]?\\d+)?");

    public GuiTextFieldDouble(int x, int y, int width, int height, class_327 fontRenderer) {
        super(x, y, width, height, fontRenderer);
        this.method_1863(this::onChanged);
    }

    protected boolean testDouble(String input) {
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected int getDoubleDecimalCount(String input) {
        try {
            int scale = BigDecimal.valueOf(Double.parseDouble(input)).scale();
            if (scale >= 0) {
                return scale;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    protected void onChanged(String newText) {
        if (!this.testDouble(newText)) {
            this.setHoverTooltip("malilib.gui.text_field.invalid_double", new Object[0]);
        } else if (newText.contains("e") || newText.contains("E") || newText.contains("e+") || newText.contains("E+") || newText.contains("e-") || newText.contains("E-")) {
            this.setHoverTooltip("malilib.gui.text_field.double_has_scientific_notation", new Object[0]);
        } else {
            int decimals = this.getDoubleDecimalCount(newText);
            if (decimals > 2) {
                this.setHoverTooltip("malilib.gui.text_field.double_has_additional_decimals", String.format("%d", decimals));
            } else {
                this.clearHoverTooltip();
            }
        }
    }
}

