/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class GsonTools {
    public static void extendJsonObject(JsonObject destinationObject, ConflictStrategy conflictResolutionStrategy, JsonObject ... objs) throws JsonObjectExtensionConflictException {
        for (JsonObject obj : objs) {
            GsonTools.extendJsonObject(destinationObject, obj, conflictResolutionStrategy);
        }
    }

    private static void extendJsonObject(JsonObject leftObj, JsonObject rightObj, ConflictStrategy conflictStrategy) throws JsonObjectExtensionConflictException {
        for (Map.Entry rightEntry : rightObj.entrySet()) {
            String rightKey = (String)rightEntry.getKey();
            JsonElement rightVal = (JsonElement)rightEntry.getValue();
            if (leftObj.has(rightKey)) {
                JsonElement leftVal = leftObj.get(rightKey);
                if (leftVal.isJsonArray() && rightVal.isJsonArray()) {
                    JsonArray leftArr = leftVal.getAsJsonArray();
                    JsonArray rightArr = rightVal.getAsJsonArray();
                    for (int i = 0; i < rightArr.size(); ++i) {
                        leftArr.add(rightArr.get(i));
                    }
                    continue;
                }
                if (leftVal.isJsonObject() && rightVal.isJsonObject()) {
                    GsonTools.extendJsonObject(leftVal.getAsJsonObject(), rightVal.getAsJsonObject(), conflictStrategy);
                    continue;
                }
                GsonTools.handleMergeConflict(rightKey, leftObj, leftVal, rightVal, conflictStrategy);
                continue;
            }
            leftObj.add(rightKey, rightVal);
        }
    }

    private static void handleMergeConflict(String key, JsonObject leftObj, JsonElement leftVal, JsonElement rightVal, ConflictStrategy conflictStrategy) throws JsonObjectExtensionConflictException {
        switch (conflictStrategy.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                leftObj.add(key, rightVal);
                break;
            }
            case 3: {
                if (!leftVal.isJsonNull() || rightVal.isJsonNull()) break;
                leftObj.add(key, rightVal);
                break;
            }
            case 0: {
                throw new JsonObjectExtensionConflictException("Key " + key + " exists in both objects and the conflict resolution strategy is " + String.valueOf((Object)conflictStrategy));
            }
            default: {
                throw new UnsupportedOperationException("The conflict strategy " + String.valueOf((Object)conflictStrategy) + " is unknown and cannot be processed");
            }
        }
    }

    public static enum ConflictStrategy {
        THROW_EXCEPTION,
        PREFER_FIRST_OBJ,
        PREFER_SECOND_OBJ,
        PREFER_NON_NULL;

    }

    public static class JsonObjectExtensionConflictException
    extends Exception {
        public JsonObjectExtensionConflictException(String message) {
            super(message);
        }
    }
}

