/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.screen.components.treeview;

import dev.kinau.myresourcepack.config.resource.ResourceDirectory;
import dev.kinau.myresourcepack.screen.components.buttons.ExpandButton;
import dev.kinau.myresourcepack.screen.components.buttons.ResourceActionbox;
import dev.kinau.myresourcepack.screen.components.treeview.TreeView;
import dev.kinau.myresourcepack.screen.components.treeview.TreeViewEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11907;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

public class TreeViewDirectoryEntry
extends TreeViewEntry {
    protected final ResourceDirectory resourceDirectory;
    protected final ExpandButton expandButton;
    protected final ResourceActionbox actionbox;
    protected final List<TreeViewEntry> directChildren = new ArrayList<TreeViewEntry>();
    protected boolean expanded = false;

    public TreeViewDirectoryEntry(TreeView treeView, @Nullable ResourceDirectory parentDirectory, @Nullable TreeViewDirectoryEntry parentEntry, int depth, final ResourceDirectory resourceDirectory) {
        super(treeView, parentDirectory, parentEntry, depth, resourceDirectory.getLabel(parentDirectory));
        this.resourceDirectory = resourceDirectory;
        this.expandButton = new ExpandButton(0, 0, 12, 12){

            @Override
            public void method_25306(class_11907 inputWithModifiers) {
                super.method_25306(inputWithModifiers);
                TreeViewDirectoryEntry.this.expanded = this.isExpanded();
                TreeViewDirectoryEntry.this.recalculateHeight();
                TreeViewDirectoryEntry.this.foreachParent(TreeViewEntry::recalculateHeight);
                TreeViewDirectoryEntry.this.triggerChange();
            }
        };
        this.children.add(this.expandButton);
        this.actionbox = new ResourceActionbox(0, 0, 12, 12, this.label, resourceDirectory.action(), treeView.getResourceTab(), resourceDirectory.supportsMerging()){

            @Override
            public void method_25306(class_11907 inputWithModifiers) {
                super.method_25306(inputWithModifiers);
                resourceDirectory.ruleAction(this.action());
                for (TreeViewEntry directChild : TreeViewDirectoryEntry.this.directChildren) {
                    for (class_364 class_3642 : directChild.allChildrenIncludingInvisible()) {
                        if (!(class_3642 instanceof ResourceActionbox)) continue;
                        ResourceActionbox childActionbox = (ResourceActionbox)class_3642;
                        childActionbox.action(this.action());
                    }
                }
                TreeViewDirectoryEntry.this.foreachParent(parentDirectoryEntry -> parentDirectoryEntry.actionbox.action(parentDirectoryEntry.resourceDirectory.action()));
            }
        };
        this.children.add(this.actionbox);
    }

    @Override
    protected int calculateHeight() {
        if (!this.expanded) {
            return super.calculateHeight();
        }
        int height = super.calculateHeight();
        for (TreeViewEntry child : this.directChildren) {
            height += child.calculateHeight();
        }
        return height;
    }

    public <T extends TreeViewEntry> void addChild(T entry) {
        this.directChildren.add(entry);
    }

    @Override
    public List<? extends class_364> method_25396() {
        if (!this.expanded) {
            return super.method_25396();
        }
        ArrayList<? extends class_364> children = new ArrayList<class_364>(super.method_25396());
        for (TreeViewEntry directChild : this.directChildren) {
            children.addAll(directChild.method_25396());
        }
        return children;
    }

    public List<class_364> allChildrenIncludingInvisible() {
        ArrayList<class_364> children = new ArrayList<class_364>(super.allChildrenIncludingInvisible());
        for (TreeViewEntry directChild : this.directChildren) {
            children.addAll(directChild.allChildrenIncludingInvisible());
        }
        return children;
    }

    @Override
    protected void renderElementContent(class_332 graphics, int x, int y, int ox, int oy, boolean hovered, float alpha) {
        this.expandButton.method_46421(x + this.getRenderDepth());
        this.expandButton.method_46419(y);
        this.expandButton.method_25394(graphics, ox, oy, alpha);
        this.actionbox.method_46421(x + this.getRenderDepth() + 20);
        this.actionbox.method_46419(y);
        this.actionbox.method_25394(graphics, ox, oy, alpha);
        if (this.expanded) {
            y += 20;
            for (TreeViewEntry directChild : this.directChildren) {
                directChild.renderElementContent(graphics, x, y, ox, oy, hovered, alpha);
                y += directChild.method_25364();
            }
        }
    }
}

