/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.mixin;

import dev.kinau.myresourcepack.MyResourcePack;
import dev.kinau.myresourcepack.config.ServerSetting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3283.class})
public class PackRepositoryMixin {
    @Inject(method={"rebuildSelected"}, at={@At(value="RETURN")}, cancellable=true)
    private void onRebuildSelected(Collection<String> collection, CallbackInfoReturnable<List<class_3288>> cir) {
        List packs = (List)cir.getReturnValue();
        if (MyResourcePack.getInstance().getCurrentServer() == null) {
            return;
        }
        if (MyResourcePack.getInstance().isConfiguringPackOrder()) {
            MyResourcePack.getInstance().setConfiguringPackOrder(false);
            for (int i = 0; i < packs.size(); ++i) {
                class_3288 pack = (class_3288)packs.get(i);
                if (pack.method_29483() != class_5352.field_25350) continue;
                boolean onlyServerPacksAbove = true;
                for (int j = packs.size() - 1; j > i; --j) {
                    if (((class_3288)packs.get(j)).method_29483() == class_5352.field_25350) continue;
                    onlyServerPacksAbove = false;
                    break;
                }
                boolean onlyServerPacksBelow = true;
                for (int j = i - 1; j >= 0; --j) {
                    if (((class_3288)packs.get(j)).method_29483() == class_5352.field_25350) continue;
                    onlyServerPacksBelow = false;
                    break;
                }
                ServerSetting setting = MyResourcePack.getInstance().getPackSettings().getConfigData().getSettings(MyResourcePack.getInstance().getCurrentServer());
                if (onlyServerPacksAbove) {
                    setting.packOrder().remove(this.getServerPackId(pack));
                    continue;
                }
                if (onlyServerPacksBelow) {
                    setting.packOrder().put(this.getServerPackId(pack), 0);
                    continue;
                }
                setting.packOrder().put(this.getServerPackId(pack), i);
            }
            try {
                MyResourcePack.getInstance().getPackSettings().saveConfig();
            }
            catch (IOException e) {
                MyResourcePack.LOGGER.error("Could not save config", (Throwable)e);
            }
            return;
        }
        cir.setReturnValue(this.reorderPacks(packs));
    }

    private List<class_3288> reorderPacks(List<class_3288> packs) {
        ArrayList<class_3288> reorderedList = new ArrayList<class_3288>(packs);
        ServerSetting setting = MyResourcePack.getInstance().getPackSettings().getConfigData().getSettings(MyResourcePack.getInstance().getCurrentServer());
        setting.packOrder().forEach((packId, orderIndex) -> reorderedList.stream().filter(pack -> this.getServerPackId((class_3288)pack).equals(packId)).findAny().ifPresent(pack -> {
            reorderedList.remove(pack);
            reorderedList.add(Math.min(orderIndex, reorderedList.size()), (class_3288)pack);
        }));
        return reorderedList;
    }

    private String getServerPackId(class_3288 pack) {
        if (pack.method_29483() != class_5352.field_25350) {
            return pack.method_14463();
        }
        int lastSlashIndex = pack.method_14463().lastIndexOf(47);
        if (lastSlashIndex < 0) {
            return pack.method_14463();
        }
        return pack.method_14463().substring(lastSlashIndex + 1);
    }
}

