/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.config;

import dev.kinau.myresourcepack.config.ResourceAction;
import dev.kinau.myresourcepack.config.resource.ResourceDirectory;
import dev.kinau.myresourcepack.config.resource.ResourceFile;
import java.util.regex.Pattern;

public class ResourceRule {
    private String rule;
    private ResourceAction action;
    private transient Pattern pattern;

    public ResourceRule(ResourceFile resourceFile) {
        this("^" + Pattern.quote(resourceFile.location().toString()) + "$", resourceFile.actionForRule());
    }

    public ResourceRule(ResourceDirectory resourceDirectory) {
        this("^(" + Pattern.quote(resourceDirectory.location().toString() + "/") + ".*|" + Pattern.quote(resourceDirectory.location().toString()) + "$)", resourceDirectory.actionForRule());
    }

    public ResourceRule(String rule, ResourceAction action) {
        this.rule = rule;
        this.action = action;
        this.pattern = Pattern.compile(rule);
    }

    public boolean matches(String path) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.rule);
        }
        return this.pattern.matcher(path).matches();
    }

    public String toString() {
        return this.rule + " \u00bb " + String.valueOf((Object)this.action);
    }

    public ResourceRule() {
    }

    public String rule() {
        return this.rule;
    }

    public ResourceAction action() {
        return this.action;
    }

    public Pattern pattern() {
        return this.pattern;
    }
}

