/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.kinau.myresourcepack.MyResourcePack;
import dev.kinau.myresourcepack.config.ServerSetting;
import java.io.IOException;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public class MyResourcePackCommand
implements ClientCommandRegistrationCallback {
    private final MyResourcePack myResourcePack;

    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"myresourcepack").then(ClientCommandManager.literal((String)"enable").executes(context -> {
            String currentServer = this.myResourcePack.getCurrentServer();
            if (currentServer == null) {
                return 1;
            }
            ServerSetting setting = this.myResourcePack.getPackSettings().getConfigData().getSettings(currentServer);
            setting.overrideTextures(false);
            class_310.method_1551().method_1521();
            try {
                this.myResourcePack.getPackSettings().saveConfig();
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Successfully enabled resource blocking!"));
            }
            catch (IOException ex) {
                MyResourcePack.LOGGER.error("Couldn't save config", (Throwable)ex);
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"disable").executes(context -> {
            String currentServer = this.myResourcePack.getCurrentServer();
            if (currentServer == null) {
                return 1;
            }
            ServerSetting setting = this.myResourcePack.getPackSettings().getConfigData().getSettings(currentServer);
            setting.overrideTextures(true);
            class_310.method_1551().method_1521();
            try {
                this.myResourcePack.getPackSettings().saveConfig();
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Successfully disabled resource blocking!"));
            }
            catch (IOException ex) {
                MyResourcePack.LOGGER.error("Couldn't save config", (Throwable)ex);
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"settings").executes(context -> {
            String currentServer = this.myResourcePack.getCurrentServer();
            if (currentServer == null) {
                return 1;
            }
            ServerSetting setting = this.myResourcePack.getPackSettings().getConfigData().getSettings(currentServer);
            if (setting.overrideTextures()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You need to enable resource blocking first: /myresourcepack enable!"));
                return 1;
            }
            this.myResourcePack.setShouldOpenConfigGui(true);
            return 1;
        })));
    }

    public MyResourcePackCommand(MyResourcePack myResourcePack) {
        this.myResourcePack = myResourcePack;
    }
}

