/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.kinau.myresourcepack.config.Config;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.fabricmc.loader.api.FabricLoader;

public class PackSettings {
    private final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final File CONFIG_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("MyResourcePack").toFile();
    private File configFile;
    private Config configData;

    public PackSettings() {
        try {
            this.loadConfig();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadConfig() throws IOException {
        this.configData = new Config();
        if (!this.CONFIG_FOLDER.exists() && !this.CONFIG_FOLDER.mkdirs()) {
            throw new IOException(String.format("Could not create folder %s", this.CONFIG_FOLDER));
        }
        this.configFile = new File(this.CONFIG_FOLDER, "config.json");
        if (this.configFile.exists()) {
            this.configData = (Config)this.GSON.fromJson((Reader)new FileReader(this.configFile), Config.class);
        }
    }

    public void saveConfig() throws IOException {
        if (this.configData == null) {
            return;
        }
        String data = this.GSON.toJson((Object)this.configData);
        Files.writeString(this.configFile.toPath(), (CharSequence)data, new OpenOption[0]);
    }

    public Config getConfigData() {
        return this.configData;
    }
}

