/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.util;

import java.lang.runtime.SwitchBootstraps;

public final class IndentingStringBuilder
implements Appendable {
    private final StringBuilder builder;
    private final String indent;

    public IndentingStringBuilder() {
        this.builder = new StringBuilder();
        this.indent = "";
    }

    public IndentingStringBuilder(StringBuilder builder, String indent) {
        this.builder = builder;
        this.indent = indent;
    }

    public String toString() {
        return this.builder.toString();
    }

    public IndentingStringBuilder line(String content) {
        if (!this.builder.isEmpty()) {
            this.builder.append('\n');
        }
        this.builder.append(this.indent).append(content.replace("\n", "\n" + this.indent));
        return this;
    }

    public IndentingStringBuilder indent() {
        return new IndentingStringBuilder(this.builder, this.indent + "    ");
    }

    @Override
    public IndentingStringBuilder append(CharSequence csq) {
        CharSequence charSequence = csq;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)charSequence, n)) {
            case -1: {
                this.builder.append("null");
                break;
            }
            case 0: {
                String s = (String)charSequence;
                this.builder.append(s.replace("\n", "\n" + this.indent));
                break;
            }
            default: {
                csq.chars().forEach(ch -> this.append((char)ch));
            }
        }
        return this;
    }

    @Override
    public IndentingStringBuilder append(CharSequence csq, int start, int end) {
        if (csq == null) {
            this.builder.append("null");
            return this;
        }
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public IndentingStringBuilder append(char c) {
        this.builder.append(c);
        if (c == '\n') {
            this.builder.append(this.indent);
        }
        return this;
    }

    public IndentingStringBuilder append(int v) {
        this.builder.append(v);
        return this;
    }
}

