/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.util;

import io.gitlab.jfronny.respackopts.model.DiscoveredPack;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public class FallbackI18n {
    private static final Map<String, String> translations = new HashMap<String, String>();

    public static void prepare(List<DiscoveredPack> discoveredPacks) {
        translations.clear();
        for (DiscoveredPack pack : discoveredPacks) {
            try {
                class_3262 rpi = pack.profile().method_14458();
                try {
                    if (rpi == null) continue;
                    translations.putAll(FallbackI18n.loadFrom(rpi, pack.meta().id));
                }
                finally {
                    if (rpi == null) continue;
                    rpi.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static Map<String, String> loadFrom(class_3262 pack, String packId) {
        HashMap<String, String> translations = new HashMap<String, String>();
        for (String namespace : pack.method_14406(class_3264.field_14188)) {
            class_7367 translation = pack.method_14405(class_3264.field_14188, class_2960.method_60655((String)namespace, (String)"lang/en_us.json"));
            if (translation == null) continue;
            try {
                InputStream is = (InputStream)translation.get();
                try {
                    class_2477.method_29425((InputStream)is, (key, value) -> {
                        if (key.startsWith("rpo." + packId + ".")) {
                            translations.put((String)key, (String)value);
                        }
                    });
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return translations;
    }

    public static void insertInto(Map<String, String> target) {
        translations.forEach(target::putIfAbsent);
    }
}

