/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.server;

import com.google.common.collect.Lists;
import io.gitlab.jfronny.commons.ref.WeakSet;
import io.gitlab.jfronny.respackopts.Respackopts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_3283;
import net.minecraft.class_5219;
import net.minecraft.server.MinecraftServer;

public class ServerInstanceHolder {
    private static final Set<MinecraftServer> SERVERS = new WeakSet();

    public static void onServerStarted(MinecraftServer server) {
        if (!SERVERS.isEmpty()) {
            Respackopts.LOGGER.warn("Multiple servers started at once. This is unexpected", new Object[0]);
        }
        if (!SERVERS.add(server)) {
            Respackopts.LOGGER.warn("Called SERVER_STARTED on a server that is already started", new Object[0]);
        }
    }

    public static void onServerStopped(MinecraftServer server) {
        if (!SERVERS.remove(server)) {
            Respackopts.LOGGER.warn("Called SERVER_STOPPED on a server that was never started/already stopped", new Object[0]);
        }
        if (!SERVERS.isEmpty()) {
            Respackopts.LOGGER.warn("Server stopped but another one is still running. This is unexpected", new Object[0]);
        }
    }

    public static void reloadResources() {
        if (SERVERS.isEmpty()) {
            Respackopts.LOGGER.warn("Attempted to reload resources while no server is running. Skipping", new Object[0]);
        }
        for (MinecraftServer server : SERVERS) {
            class_3283 manager = server.method_3836();
            class_5219 saveProperties = server.method_27728();
            ArrayList enabled = Lists.newArrayList((Iterable)manager.method_29210());
            manager.method_14445();
            List disabled = saveProperties.method_29589().comp_1010().method_29550();
            for (String name : manager.method_29206()) {
                if (disabled.contains(name) || enabled.contains(name)) continue;
                enabled.add(name);
            }
            server.method_29439((Collection)enabled).exceptionally(throwable -> {
                Respackopts.LOGGER.warn("Failed to reload data packs", throwable);
                return null;
            });
        }
    }
}

