/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.serialization;

import io.gitlab.jfronny.commons.concurrent.ScopedValue;
import io.gitlab.jfronny.commons.throwable.ExceptionWrapper;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.util.function.Supplier;

public class AttachmentHolder {
    private static final ScopedValue<Attachment> attachments = ScopedValue.newInstance();

    public static <TEx extends Throwable> void attach(int version, ThrowingRunnable<TEx> runnable) throws TEx {
        try {
            ScopedValue.runWhere(attachments, (Object)new Attachment(version), (Runnable)runnable.orThrow());
        }
        catch (ExceptionWrapper e) {
            throw ExceptionWrapper.unwrap((Throwable)e);
        }
    }

    public static <TOut, TEx extends Throwable> TOut attach(int version, ThrowingSupplier<TOut, TEx> runnable) throws TEx {
        try {
            return (TOut)ScopedValue.getWhere(attachments, (Object)new Attachment(version), (Supplier)runnable.orThrow());
        }
        catch (ExceptionWrapper e) {
            throw ExceptionWrapper.unwrap((Throwable)e);
        }
    }

    public static int getAttachedVersion() {
        return ((Attachment)AttachmentHolder.attachments.get()).version;
    }

    private record Attachment(int version) {
    }
}

