/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.tree;

import io.gitlab.jfronny.commons.serialize.databind.api.SerializeWithAdapter;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.model.tree.ConfigEntry;
import io.gitlab.jfronny.respackopts.model.tree.GuiEntryBuilderParam;
import io.gitlab.jfronny.respackopts.serialization.entry.StringEntryTypeAdapter;
import io.gitlab.jfronny.respackopts.util.IndentingStringBuilder;
import java.util.Objects;

@SerializeWithAdapter(adapter=StringEntryTypeAdapter.class)
public class ConfigStringEntry
extends ConfigEntry<String>
implements DString {
    public ConfigStringEntry(String v) {
        super(String.class);
        this.setValue(v);
        this.setDefault(v);
    }

    @Override
    public ConfigEntry<String> clone() {
        ConfigStringEntry be = new ConfigStringEntry((String)this.getValue());
        be.setDefault((String)this.getDefault());
        return be;
    }

    @Override
    public void buildShader(IndentingStringBuilder sb, String valueName) {
    }

    @Override
    public CategoryBuilder<?> buildEntry(GuiEntryBuilderParam args) {
        return args.builder().value(args.name(), (String)this.getDefault(), this::getValue, v -> {
            boolean changed = !Objects.equals(this.getValue(), v);
            this.setValue(v);
            if (changed) {
                if (RespackoptsConfig.debugLogs) {
                    Respackopts.LOGGER.info("ConfigStringEntry SaveCallback", new Object[0]);
                }
                args.saveCallback();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) return false;
        if (!(o instanceof ConfigStringEntry)) return false;
        ConfigStringEntry cb = (ConfigStringEntry)o;
        if (!((String)this.getValue()).equals(cb.getValue())) return false;
        if (!((String)this.getDefault()).equals(cb.getDefault())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue(), this.getDefault());
    }
}

