/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.tree;

import io.gitlab.jfronny.commons.serialize.databind.api.SerializeWithAdapter;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.muscript.data.additional.DEnum;
import io.gitlab.jfronny.muscript.data.additional.DelegateDynamic;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.model.enums.ConfigSyncMode;
import io.gitlab.jfronny.respackopts.model.enums.PackReloadType;
import io.gitlab.jfronny.respackopts.model.tree.ConfigEntry;
import io.gitlab.jfronny.respackopts.model.tree.GuiEntryBuilderParam;
import io.gitlab.jfronny.respackopts.serialization.entry.EnumEntryTypeAdapter;
import io.gitlab.jfronny.respackopts.util.IndentingStringBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@SerializeWithAdapter(adapter=EnumEntryTypeAdapter.class)
public class ConfigEnumEntry
extends ConfigEntry<String>
implements DelegateDynamic {
    private final List<String> values = new ArrayList<String>();
    private Integer nextValue;

    public ConfigEnumEntry() {
        super(String.class);
    }

    public void setNextValue(int v) {
        this.nextValue = v;
    }

    @Override
    public String getValue() {
        String v = (String)super.getValue();
        if (v == null) {
            if (this.nextValue != null && this.nextValue >= 0 && this.nextValue < this.values.size()) {
                v = this.values.get(this.nextValue);
                this.setValue(v);
            } else {
                throw new NullPointerException("Could not get value in " + this.getName());
            }
        }
        return v;
    }

    @Override
    public String getDefault() {
        String v = (String)super.getDefault();
        if (v == null) {
            if (this.values.isEmpty()) {
                throw new NullPointerException("Could not get default entry as the entry array is empty in " + this.getName());
            }
            v = this.values.getFirst();
        }
        return v;
    }

    public List<String> getValues() {
        return List.copyOf(this.values);
    }

    public void setValues(List<String> replacement) {
        this.values.clear();
        this.values.addAll(replacement);
        this.checkValues();
    }

    @Override
    public void setVersion(int version) {
        super.setVersion(version);
        this.checkValues();
    }

    private void checkValues() {
        if (this.version < 10) {
            return;
        }
        Iterator<String> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (Respackopts.isLegal(value)) continue;
            Respackopts.LOGGER.error("Illegal enum entry for {0}, skipping: {1}", new Object[]{this.getName(), value});
            iterator.remove();
        }
    }

    @Override
    public PackReloadType sync(ConfigEntry<String> source, ConfigSyncMode mode) {
        PackReloadType result = super.sync(source, mode);
        ConfigEnumEntry n = (ConfigEnumEntry)source;
        if (mode == ConfigSyncMode.RESPACK_LOAD && !n.values.isEmpty()) {
            this.setValues(n.values);
        }
        if (this.nextValue != null) {
            if (this.getValue() == null) {
                if (n.nextValue >= 0 && n.nextValue < this.values.size()) {
                    this.setValue(this.values.get(n.nextValue));
                    result = this.getReloadType();
                } else {
                    Respackopts.LOGGER.error("Could not load default value for enum in {0}", new Object[]{this.getName()});
                }
            } else {
                this.nextValue = null;
            }
        }
        return result;
    }

    @Override
    public void appendString(IndentingStringBuilder sb) {
        sb.line(this.getValue() + " (default=" + this.getDefault() + ") of:");
        IndentingStringBuilder isb = sb.indent();
        for (String e : this.values) {
            isb.line("- " + e);
        }
    }

    @Override
    public ConfigEntry<String> clone() {
        ConfigEnumEntry e = new ConfigEnumEntry();
        e.nextValue = this.nextValue;
        e.values.addAll(this.values);
        e.setValue(this.getValue());
        e.setDefault(this.getDefault());
        return e;
    }

    @Override
    public void buildShader(IndentingStringBuilder sb, String valueName) {
        if (!this.values.contains("index")) {
            sb.append("\n#define ");
            sb.append(valueName);
            sb.append("_index ");
            sb.append(this.values.indexOf(this.getValue()));
        }
        for (int i = 0; i < this.values.size(); ++i) {
            String e2 = Respackopts.sanitizeString(this.values.get(i));
            if (this.version == 1) {
                sb.append("\n#define ");
                sb.append(valueName);
                sb.append('_');
                sb.append(e2);
                sb.append(' ');
                sb.append(i);
                continue;
            }
            if (!e2.equals(this.getValue())) continue;
            sb.append("\n#define ");
            sb.append(valueName);
            sb.append('_');
            sb.append(e2);
        }
    }

    public Dynamic getDelegate() {
        return new DEnum(this.values, this.getValue());
    }

    @Override
    public CategoryBuilder<?> buildEntry(GuiEntryBuilderParam args) {
        return args.builder().value(args.name(), this.getDefault(), (String[])this.values.toArray(String[]::new), this::getValue, v -> {
            boolean changed = !Objects.equals(this.getValue(), v);
            this.setValue(v);
            if (changed) {
                if (RespackoptsConfig.debugLogs) {
                    Respackopts.LOGGER.info("ConfigEnumEntry SaveCallback", new Object[0]);
                }
                args.saveCallback();
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigEnumEntry)) {
            return false;
        }
        ConfigEnumEntry that = (ConfigEnumEntry)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getDefault(), that.getDefault()) && Objects.equals(this.values, that.values) && Objects.equals(this.nextValue, that.nextValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue(), this.getDefault(), this.values, this.nextValue);
    }
}

