/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.tree;

import io.gitlab.jfronny.commons.serialize.databind.api.SerializeWithAdapter;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.muscript.data.dynamic.DynamicBase;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.model.enums.ConfigSyncMode;
import io.gitlab.jfronny.respackopts.model.enums.PackReloadType;
import io.gitlab.jfronny.respackopts.model.tree.ConfigBranch;
import io.gitlab.jfronny.respackopts.model.tree.GuiEntryBuilderParam;
import io.gitlab.jfronny.respackopts.serialization.ConfigEntryTypeAdapter;
import io.gitlab.jfronny.respackopts.util.IndentingStringBuilder;
import java.util.Objects;

@SerializeWithAdapter(adapter=ConfigEntryTypeAdapter.class)
public abstract class ConfigEntry<T>
implements DynamicBase {
    private final Class<? super T> entryClass;
    private T defaultValue;
    private T value;
    private PackReloadType reloadType = PackReloadType.Resource;
    protected int version;
    protected ConfigBranch parent;

    public ConfigEntry(Class<? super T> entryClass) {
        this.entryClass = entryClass;
    }

    public String getName() {
        if (this.parent == null) {
            return "";
        }
        Object n = this.parent.getName() + "." + this.parent.getEntryName(this);
        if (((String)n).startsWith(".")) {
            n = ((String)n).substring(1);
        }
        return n;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public T getValue() {
        if (this.value == null) {
            if (this.defaultValue == null) {
                Respackopts.LOGGER.warn("No default value or current value set for entry, returning null in {0}", new Object[]{this.getName()});
                return null;
            }
            this.value = this.getDefault();
        }
        return this.value;
    }

    public T setValue(T value) {
        if (value != null) {
            this.value = value;
        }
        return this.value;
    }

    public T getDefault() {
        if (this.defaultValue == null) {
            this.defaultValue = this.getValue();
            Respackopts.LOGGER.warn("No default value set for entry, using current in {0}", new Object[]{this.getName()});
        }
        return this.defaultValue;
    }

    public T setDefault(T value) {
        if (value != null) {
            this.defaultValue = value;
        }
        return this.defaultValue;
    }

    public boolean hasDefault() {
        return this.defaultValue != null;
    }

    public PackReloadType sync(ConfigEntry<T> source, ConfigSyncMode mode) {
        if (mode == ConfigSyncMode.RESPACK_LOAD) {
            this.setDefault(source.getDefault());
        }
        if (mode == ConfigSyncMode.CONF_LOAD) {
            T previous = this.getValue();
            T modified = source.getValue();
            this.setValue(modified);
            return Objects.equals(previous, modified) ? PackReloadType.Simple : this.getReloadType();
        }
        return PackReloadType.Simple;
    }

    public void appendString(IndentingStringBuilder sb) {
        sb.line(String.valueOf(this.getValue()) + " (" + String.valueOf(this.getDefault()) + ")");
    }

    public String toString() {
        IndentingStringBuilder log = new IndentingStringBuilder();
        this.appendString(log);
        return log.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigEntry)) {
            return false;
        }
        ConfigEntry that = (ConfigEntry)o;
        return this.version == that.version && Objects.equals(this.entryClass, that.entryClass) && this.reloadType == that.reloadType && this.parent == null == (that.parent == null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entryClass, this.reloadType, this.version, this.parent == null});
    }

    public abstract ConfigEntry<T> clone();

    public abstract void buildShader(IndentingStringBuilder var1, String var2);

    public abstract CategoryBuilder<?> buildEntry(GuiEntryBuilderParam var1);

    public Class<? super T> getEntryClass() {
        return this.entryClass;
    }

    public PackReloadType getReloadType() {
        return this.reloadType;
    }

    public void setReloadType(PackReloadType reloadType) {
        this.reloadType = reloadType;
    }

    public ConfigBranch getParent() {
        return this.parent;
    }
}

