/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.naming;

import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.model.naming.NameGuesser;
import io.gitlab.jfronny.respackopts.model.tree.ConfigBranch;
import java.util.Objects;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class BranchNaming
implements Naming {
    private final String name;
    private final String path;
    private final int version;

    public BranchNaming(String packId, ConfigBranch cb) {
        this(packId, packId, cb.getVersion());
    }

    public BranchNaming(String packId) {
        this(packId, packId, Respackopts.META_VERSION);
    }

    private BranchNaming(String name, String path, int version) {
        this.name = name;
        this.path = path;
        this.version = version;
    }

    private static class_2561 maybeFallback(String key, String fallback) {
        if (!RespackoptsConfig.generateNames) {
            return class_2561.method_43471((String)key);
        }
        return class_2561.method_48321((String)key, (String)NameGuesser.guess(fallback));
    }

    @Nullable
    private static class_2561 maybeText(String key) {
        return class_2477.method_10517().method_4678(key) ? class_2561.method_43471((String)key) : null;
    }

    public class_2561 name() {
        return this.version < 3 ? BranchNaming.maybeFallback("respackopts.title." + this.path, this.name) : BranchNaming.maybeFallback("rpo." + this.path, this.name);
    }

    @Nullable
    public class_2561 description() {
        return this.version < 3 ? BranchNaming.maybeText("respackopts.tooltip." + this.path) : (this.version < 9 ? BranchNaming.maybeText("rpo.tooltip." + this.path) : BranchNaming.maybeText("rpo." + this.path + ".tooltip"));
    }

    public class_2561 preset(String name) {
        return BranchNaming.maybeFallback("rpo." + this.path + "." + name, name);
    }

    public Naming category(String name) {
        return new BranchNaming(name, this.path + "." + name, this.version);
    }

    public Naming.Entry entry(final String name) {
        return new Naming.Entry(){

            private String fieldPath() {
                return BranchNaming.this.version < 3 ? "respackopts.field." + BranchNaming.this.path + "." + name : "rpo." + BranchNaming.this.path + "." + name;
            }

            public class_2561 name() {
                return BranchNaming.maybeFallback(this.fieldPath(), name);
            }

            @Nullable
            public class_2561 tooltip() {
                return BranchNaming.this.version < 3 ? BranchNaming.maybeText("respackopts.tooltip." + BranchNaming.this.path + "." + name) : (BranchNaming.this.version < 9 ? BranchNaming.maybeText("rpo.tooltip." + BranchNaming.this.path + "." + name) : BranchNaming.maybeText("rpo." + BranchNaming.this.path + "." + name + ".tooltip"));
            }

            public class_2561 boolValue(boolean value) {
                String bs = Boolean.toString(value);
                String path = this.fieldPath() + "." + value;
                return class_2477.method_10517().method_4678(path) ? class_2561.method_48321((String)path, (String)bs) : class_2561.method_48321((String)("libjf-config-core-v2." + value), (String)bs);
            }

            public class_2561 enumValue(Type type, Object value) {
                String bs = Objects.toString(value);
                return BranchNaming.maybeFallback(this.fieldPath() + "." + bs, bs);
            }

            public class_2561 nullValue() {
                return class_2561.method_48321((String)"libjf-config-core-v2.null", (String)"null");
            }
        };
    }
}

