/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.Transport;
import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedReader;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedWriter;
import io.gitlab.jfronny.respackopts.model.PackMeta;
import io.gitlab.jfronny.respackopts.model.enums.PackCapability;
import io.gitlab.jfronny.respackopts.model.tree.ConfigBranch;
import io.gitlab.jfronny.respackopts.serialization.entry.ConfigBranchTypeAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class GC_PackMeta {
    private static final ConfigBranchTypeAdapter adapter_conf = new ConfigBranchTypeAdapter();

    public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(PackMeta value, Writer writer) throws TEx, MalformedDataException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (value.conf != null || writer.isSerializeNulls()) {
            writer.name("conf");
            if (value.conf == null) {
                writer.nullValue();
            } else {
                adapter_conf.serialize(value.conf, writer);
            }
        }
        writer.name("version");
        writer.value((long)value.version);
        if (value.id != null || writer.isSerializeNulls()) {
            writer.name("id");
            if (value.id == null) {
                writer.nullValue();
            } else {
                writer.value(value.id);
            }
        }
        if (value.capabilities != null || writer.isSerializeNulls()) {
            writer.name("capabilities");
            if (value.capabilities == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                for (PackCapability _capabilities : value.capabilities) {
                    if (_capabilities == null) {
                        if (!writer.isSerializeNulls()) continue;
                        writer.nullValue();
                        continue;
                    }
                    writer.value(_capabilities.name());
                }
                writer.endArray();
            }
        }
        writer.endObject();
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> PackCapability read$_capabilities(Reader reader) throws TEx, MalformedDataException {
        String value = reader.nextString();
        for (PackCapability t : PackCapability.values()) {
            if (!t.name().equals(value)) continue;
            return t;
        }
        return null;
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Set<PackCapability> read$capabilities(Reader reader) throws TEx, MalformedDataException {
        LinkedHashSet<PackCapability> list = new LinkedHashSet<PackCapability>();
        if (reader.isLenient() && reader.peek() != Token.BEGIN_ARRAY) {
            list.add(GC_PackMeta.read$_capabilities(reader));
            return list;
        }
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                list.add(null);
                continue;
            }
            list.add(GC_PackMeta.read$_capabilities(reader));
        }
        reader.endArray();
        return list;
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> PackMeta deserialize(Reader reader) throws TEx, MalformedDataException {
        if (reader.peek() == Token.NULL) {
            reader.nextNull();
            return null;
        }
        String _id = null;
        boolean has_id = false;
        int _version = 0;
        boolean has_version = false;
        Object _conf = null;
        boolean has_conf = false;
        Set<PackCapability> _capabilities = null;
        boolean has_capabilities = false;
        reader.beginObject();
        block6: while (reader.hasNext()) {
            String string;
            Objects.requireNonNull(reader.nextName());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"id", "version", "conf", "capabilities", String.class}, (Object)string, n)) {
                case 0: {
                    if (has_id && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: id");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _id = null;
                    } else {
                        _id = reader.nextString();
                    }
                    has_id = true;
                    continue block6;
                }
                case 1: {
                    if (has_version && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: version");
                    }
                    _version = reader.nextInt();
                    has_version = true;
                    continue block6;
                }
                case 2: {
                    if (has_conf && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: conf");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _conf = null;
                    } else {
                        _conf = adapter_conf.deserialize((SerializeReader)reader);
                    }
                    has_conf = true;
                    continue block6;
                }
                case 3: {
                    if (has_capabilities && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: capabilities");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _capabilities = null;
                    } else {
                        _capabilities = GC_PackMeta.read$capabilities(reader);
                    }
                    has_capabilities = true;
                    continue block6;
                }
            }
            String s = string;
            if (reader.isLenient()) {
                reader.skipValue();
                continue;
            }
            throw new MalformedDataException("Unexpected name: " + s);
        }
        reader.endObject();
        PackMeta result = new PackMeta(_id, _version, (ConfigBranch)_conf);
        if (has_capabilities) {
            result.capabilities = _capabilities;
        }
        return result;
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> PackMeta deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        return (PackMeta)transport.read(in, reader -> GC_PackMeta.deserialize(reader));
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> PackMeta deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        try (StringReader reader = new StringReader(serialized);){
            PackMeta packMeta = GC_PackMeta.deserialize(reader, transport);
            return packMeta;
        }
    }

    public static PackMeta deserialize(DataElement tree) throws MalformedDataException {
        try (EmulatedReader reader = new EmulatedReader(tree);){
            PackMeta packMeta = GC_PackMeta.deserialize(reader);
            return packMeta;
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> PackMeta deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            PackMeta packMeta = GC_PackMeta.deserialize(reader, transport);
            return packMeta;
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(PackMeta value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        transport.write(out, writer -> GC_PackMeta.serialize(value, writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(PackMeta value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            GC_PackMeta.serialize(value, writer, transport);
            Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(temp);
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(PackMeta value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        return transport.write(writer -> GC_PackMeta.serialize(value, writer));
    }

    public static DataElement toDataTree(PackMeta value) throws MalformedDataException {
        try (EmulatedWriter writer = new EmulatedWriter();){
            GC_PackMeta.serialize(value, writer);
            DataElement dataElement = writer.get();
            return dataElement;
        }
    }
}

