/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.mixin;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.mixin.DirectoryResourcePackAccessor;
import io.gitlab.jfronny.respackopts.mixin.ZipFileWrapperAccessor;
import io.gitlab.jfronny.respackopts.mixin.ZipResourcePackAccessor;
import io.gitlab.jfronny.respackopts.model.DiscoveredPack;
import io.gitlab.jfronny.respackopts.model.GC_PackMeta;
import io.gitlab.jfronny.respackopts.model.PackMeta;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.model.tree.ConfigBranch;
import io.gitlab.jfronny.respackopts.model.tree.GC_ConfigBranch;
import io.gitlab.jfronny.respackopts.platform.Platform;
import io.gitlab.jfronny.respackopts.util.FallbackI18n;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3283.class})
public class ResourcePackManagerMixin {
    @Shadow
    private Map<String, class_3288> field_14226;
    @Unique
    private final Set<CacheKey> rpo$cache = new HashSet<CacheKey>();

    @Inject(at={@At(value="TAIL")}, method={"method_14445()V"})
    private void scanPacks(CallbackInfo info) {
        RespackoptsConfig.scanState = RespackoptsConfig.ScanState.SCANNING;
        ArrayList<DiscoveredPack> discoveredPacks = new ArrayList<DiscoveredPack>();
        this.field_14226.forEach((s, v) -> {
            try (class_3262 rpi = v.method_14458();){
                DiscoveredPack dp = ResourcePackManagerMixin.rpo$checkProfile(s, v.method_14457().getString(), v, rpi);
                if (dp != null) {
                    discoveredPacks.add(dp);
                }
            }
        });
        Set<CacheKey> newKeys = MetaCache.addFromScan(discoveredPacks, this.rpo$cache);
        this.rpo$cache.clear();
        this.rpo$cache.addAll(newKeys);
        RespackoptsConfig.scanState = RespackoptsConfig.ScanState.DONE;
        FallbackI18n.prepare(discoveredPacks);
    }

    @Unique
    @Nullable
    private static DiscoveredPack rpo$checkProfile(String profileName, String displayName, class_3288 profile, class_3262 rpi) {
        class_7367 conf;
        Path dataLocation;
        block27: {
            Object pack;
            dataLocation = null;
            if (rpi instanceof class_3259) {
                class_3259 drp = (class_3259)rpi;
                pack = ((DirectoryResourcePackAccessor)drp).getRoot();
                Path path = parent = pack == null ? null : pack.getParent();
                if (parent != null) {
                    dataLocation = parent.resolve(String.valueOf(pack.getFileName()) + ".rpo");
                } else {
                    Respackopts.LOGGER.warn("Base path of directory resource pack {0} is null. This shouldn't happen!", new Object[]{rpi.method_14409()});
                }
            } else if (rpi instanceof class_3258) {
                class_3258 zrp = (class_3258)rpi;
                pack = ((ZipFileWrapperAccessor)((ZipResourcePackAccessor)zrp).getZipFile()).getFile();
                Path path = parent = pack == null ? null : ((File)pack).toPath().getParent();
                if (parent != null) {
                    dataLocation = parent.resolve(((File)pack).getName() + ".rpo");
                } else {
                    Respackopts.LOGGER.warn("Base path of zip resource pack {0} is null. This shouldn't happen!", new Object[]{rpi.method_14409()});
                }
            }
            conf = rpi.method_14410(new String[]{"respackopts.json5"});
            if (conf != null) {
                block26: {
                    InputStream is = (InputStream)conf.get();
                    try {
                        pack = ResourcePackManagerMixin.rpo$readConfiguration(profile, rpi, is, dataLocation, displayName);
                        if (is == null) break block26;
                    }
                    catch (Throwable pack2) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    pack2.addSuppressed(throwable);
                                }
                            }
                            throw pack2;
                        }
                        catch (Throwable e) {
                            String message = "Could not read Respackopts config in root for " + profileName;
                            if (RespackoptsConfig.debugLogs) {
                                Respackopts.LOGGER.error(message, e);
                                break block27;
                            }
                            Respackopts.LOGGER.error(message, new Object[0]);
                        }
                    }
                    is.close();
                }
                return pack;
            }
        }
        class_2960 confId = class_2960.method_60655((String)"respackopts", (String)"conf.json");
        for (class_3264 type : class_3264.values()) {
            DiscoveredPack discoveredPack;
            block28: {
                conf = rpi.method_14405(type, confId);
                if (conf == null) continue;
                InputStream is = (InputStream)conf.get();
                try {
                    discoveredPack = ResourcePackManagerMixin.rpo$readConfiguration(profile, rpi, is, dataLocation, displayName);
                    if (is == null) break block28;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        Respackopts.LOGGER.error("Could not initialize pack meta for " + profileName, e);
                    }
                }
                is.close();
            }
            return discoveredPack;
        }
        return null;
    }

    @Unique
    @Nullable
    private static DiscoveredPack rpo$readConfiguration(class_3288 profile, class_3262 pack, InputStream is, Path dataLocation, String displayName) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is);){
            PackMeta meta = GC_PackMeta.deserialize(isr, LibJf.LENIENT_TRANSPORT);
            if (!Respackopts.isLegal(meta.id)) {
                if (meta.version >= 10) {
                    Respackopts.LOGGER.error("{0} was not loaded as it uses an unsupported pack id: {1}", new Object[]{displayName, meta.id});
                    DiscoveredPack discoveredPack = null;
                    return discoveredPack;
                }
                meta.id = Respackopts.sanitizeString(meta.id);
            }
            if (RespackoptsConfig.debugLogs) {
                Respackopts.LOGGER.info("Discovered pack: {0}", new Object[]{meta.id});
            }
            if (Respackopts.META_VERSION < meta.version) {
                Respackopts.LOGGER.error("{0} was not loaded as it specifies a newer respackopts version than is installed", new Object[]{displayName});
                DiscoveredPack discoveredPack = null;
                return discoveredPack;
            }
            if (meta.version >= 13) {
                meta.conf.setPresets(ResourcePackManagerMixin.rpo$findPresets(pack));
            }
            if (dataLocation == null) {
                dataLocation = Respackopts.FALLBACK_CONF_DIR.resolve(meta.id + ".json");
            }
            DiscoveredPack discoveredPack = new DiscoveredPack(profile, pack.method_14409(), meta, dataLocation);
            return discoveredPack;
        }
    }

    @Unique
    private static Map<String, class_7367<ConfigBranch>> rpo$findPresets(class_3262 pack) throws IOException {
        HashMap<String, class_7367<ConfigBranch>> presets = new HashMap<String, class_7367<ConfigBranch>>();
        for (class_3264 type : class_3264.values()) {
            if (type == class_3264.field_14188 && Platform.getInstance().isDedicatedServer()) continue;
            pack.method_14408(type, "respackopts", "presets", (s, r) -> {
                String path = s.method_12832();
                if (path.endsWith(".json5")) {
                    presets.put("preset." + path.substring(8, path.length() - 6), () -> {
                        class_7367 supplier = pack.method_14405(type, s);
                        if (supplier == null) {
                            throw new FileNotFoundException("Could not open preset " + path + " in " + String.valueOf(s));
                        }
                        try (InputStream is = (InputStream)supplier.get();){
                            ConfigBranch configBranch;
                            try (InputStreamReader isr = new InputStreamReader(is);){
                                configBranch = GC_ConfigBranch.deserialize(isr, LibJf.LENIENT_TRANSPORT);
                            }
                            return configBranch;
                        }
                    });
                }
            });
        }
        return presets;
    }
}

