/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters.util;

import io.gitlab.jfronny.libjf.ResourcePath;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.filters.util.FileRpoSearchProvider;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.muscript.RespackoptsFS;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.InputStream;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public class FileFallbackProvider {
    public static class_7367<InputStream> getReplacement(CacheKey key, RespackoptsFS fs, String file) {
        return FileRpoSearchProvider.modifyWithRpo(file, key, fs, rpo -> {
            if (rpo.fallbacks == null) {
                return null;
            }
            try {
                for (String s : rpo.fallbacks) {
                    MetaCache.addDependency(key, file, s);
                    class_7367<InputStream> is = fs.open(s);
                    if (is == null) continue;
                    return is;
                }
                Respackopts.LOGGER.error("Could not determine replacement for {0}", new Object[]{file});
            }
            catch (Exception e) {
                Respackopts.LOGGER.error("Could not determine replacement for {0}", (Throwable)e, new Object[]{file});
            }
            return null;
        }, null);
    }

    public static void addFallbackResources(class_3264 type, String namespace, String prefix, class_3262.class_7664 previous, CacheKey key, RespackoptsFS fs, class_2960 identifier, Set<class_2960> alreadyConsumed) {
        ResourcePath path = new ResourcePath(type, identifier);
        if (!FileRpoSearchProvider.isRpo(path)) {
            return;
        }
        ResourcePath expectedTarget = FileFallbackProvider.mapPath(path, s -> s.substring(0, s.length() - ".rpo".length()));
        if (alreadyConsumed.contains(expectedTarget.getId())) {
            return;
        }
        class_7367<InputStream> replacement = fs.open(expectedTarget.getType(), expectedTarget.getId());
        if (replacement == null) {
            return;
        }
        alreadyConsumed.add(expectedTarget.getId());
        previous.accept((Object)expectedTarget.getId(), replacement);
    }

    private static ResourcePath mapPath(ResourcePath path, UnaryOperator<String> mapper) {
        return new ResourcePath(path.getType(), path.getId().method_45134(mapper));
    }
}

