/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters.util;

import io.gitlab.jfronny.respackopts.Respackopts;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FileDependencyTracker {
    private final String pack;
    private final Map<String, Set<String>> dependencies = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> dependents = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> reportedRecursions = ConcurrentHashMap.newKeySet();

    public FileDependencyTracker(String pack) {
        this.pack = pack;
    }

    public void addDependency(String to, String on) {
        if (to.equals(on)) {
            if (this.reportedRecursions.add(to)) {
                Respackopts.LOGGER.warn("Discovered recursive dependency in {0}! If you get a StackOverflowException, please validate your fallbacks for {1}", new Object[]{this.pack, to});
            }
            return;
        }
        this.gs(this.dependencies, to).add(on);
        this.gs(this.dependents, on).add(to);
        this.gs(this.dependents, to).forEach(dp -> this.addDependency((String)dp, on));
        this.gs(this.dependencies, on).forEach(dp -> this.addDependency(to, (String)dp));
    }

    private Set<String> gs(Map<String, Set<String>> map, String key) {
        return map.computeIfAbsent(key, _1 -> new HashSet());
    }

    public String toString() {
        return "FileDependencyTracker{pack='" + this.pack + "', dependencies=" + String.valueOf(this.dependencies) + ", dependents=" + String.valueOf(this.dependents) + "}";
    }
}

