/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.unsafe.reflect.Reflect;
import io.gitlab.jfronny.libjf.ResourcePath;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.filters.IEvents;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3300;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;

public class ValidationLayer {
    private static final ThreadLocal<SequencedMap<Frame, Integer>> stack = ThreadLocal.withInitial(LinkedHashMap::new);
    private static final int MAX_RECURSION = 15;
    private static final SystemLoggerPlus LOG = SystemLoggerPlus.forName((String)"respackopts/validationLayer");
    public static class_2960 RELOAD_IDENTIFIER = class_2960.method_60655((String)"respackopts", (String)"validation_layer");

    public static void onReload(class_3300 manager) {
        try {
            Thread[] threads = new Thread[Thread.activeCount() + 1];
            if (Thread.enumerate(threads) == threads.length) {
                LOG.warn("Thread array too small, some threads may not be checked", new Object[0]);
            }
            BiFunction fn = Reflect.instanceFunction(ThreadLocal.class, (String)"get", Object.class, Thread.class);
            for (Thread thread : threads) {
                SequencedMap map;
                Object value;
                if (thread == null || !((value = fn.apply(stack, thread)) instanceof SequencedMap) || (map = (SequencedMap)value).isEmpty()) continue;
                LOG.info("Thread " + thread.getName() + " returned with stack " + String.valueOf(map.keySet()), new Object[0]);
                map.clear();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void push(String name) {
        SequencedMap<Frame, Integer> stack = ValidationLayer.stack.get();
        int frame = stack.merge(new Frame.Resource(name), 1, Integer::sum);
        if (frame > 15) {
            throw new RuntimeException("[validationLayer] Detected infinite recursion while trying to load " + name + ". Stack of resources was " + String.valueOf(stack.keySet()));
        }
        if (frame > 2) {
            LOG.warn("Detected possible infinite recursion while trying to load {0}. Stack of resources was {1}", new Object[]{stack.firstEntry().getKey(), stack.keySet()});
        }
    }

    public static void pop(String name) {
        stack.get().compute(new Frame.Resource(name), (k, v) -> {
            if (v == null) {
                LOG.warn("[validationLayer] Frame not found for " + name, new Object[0]);
                return null;
            }
            return v == 1 ? null : Integer.valueOf(v - 1);
        });
    }

    private static sealed interface Frame {

        public record Resource(String name) implements Frame
        {
            @Override
            @NotNull
            public String toString() {
                return this.name;
            }
        }
    }

    public static class Post
    implements IEvents {
        @Override
        public class_7367<InputStream> open(class_7367<InputStream> previous, class_3262 pack, String name) {
            if (!RespackoptsConfig.validationLayer) {
                return previous;
            }
            ValidationLayer.pop(name);
            return previous;
        }

        @Override
        public class_3262.class_7664 findResources(class_3264 type, String namespace, String prefix, class_3262.class_7664 previous, class_3262 pack) {
            class_3262.class_7664 openPrev = IEvents.super.findResources(type, namespace, prefix, previous, pack);
            return (id, isr) -> {
                if (isr == null) {
                    LOG.error("ResourcePack {0} caused findResources to return null for {1} in {2} of {3}", new Object[]{pack.method_14409(), id, namespace, prefix});
                }
                openPrev.accept(id, isr);
            };
        }
    }

    public static class Pre
    implements IEvents {
        private static final Pattern FALLBACK_I18N = Pattern.compile("assets/[0-9a-z_.-]+/lang/en_us.json");

        @Override
        public class_7367<InputStream> open(class_7367<InputStream> previous, class_3262 pack, String name) {
            if (!RespackoptsConfig.validationLayer) {
                return previous;
            }
            ValidationLayer.push(name);
            switch (RespackoptsConfig.scanState) {
                case NONE: {
                    if (this.isPermittedWithoutScan(pack, name)) break;
                    LOG.warn("ResourcePack {0} tried to access {1} even though scanning has not started yet", new Object[]{pack.method_14409(), name});
                    break;
                }
                case SCANNING: {
                    if (this.isPermittedDuringScan(pack, name)) break;
                    LOG.warn("ResourcePack {0} tried to access {1} before scanning is done", new Object[]{pack.method_14409(), name});
                }
            }
            return previous;
        }

        private boolean isPermittedDuringScan(class_3262 pack, String name) {
            if (name.endsWith(".rpo")) {
                return this.isPermittedDuringScan(pack, name.substring(0, name.length() - ".rpo".length()));
            }
            if (this.isPermittedWithoutScan(pack, name)) {
                return true;
            }
            if (name.equals("respackopts.json5")) {
                return true;
            }
            for (class_3264 value : class_3264.values()) {
                if (!name.equals(new ResourcePath(value, class_2960.method_60655((String)"respackopts", (String)"conf.json")).getName())) continue;
                return true;
            }
            return FALLBACK_I18N.matcher(name).matches();
        }

        private boolean isPermittedWithoutScan(class_3262 pack, String name) {
            return switch (name) {
                case "pack.mcmeta" -> true;
                case "icons/icon_16x16.png", "icons/icon_32x32.png", "icons/icon_48x48.png", "icons/icon_128x128.png", "icons/icon_256x256.png" -> pack instanceof class_3268;
                default -> false;
            };
        }
    }
}

