/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts;

import io.gitlab.jfronny.libjf.config.api.v2.Entry;
import io.gitlab.jfronny.libjf.config.api.v2.JfConfig;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.DSL;
import io.gitlab.jfronny.respackopts.JFC_RespackoptsConfig;
import io.gitlab.jfronny.respackopts.platform.Platform;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;

@JfConfig(tweaker=Tweaker.class)
public class RespackoptsConfig {
    @Entry
    public static boolean debugCommands = false;
    @Entry
    public static boolean debugLogs = false;
    @Entry
    public static boolean generateNames = true;
    @Entry
    public static boolean validationLayer = false;
    @Entry
    public static boolean ioLogs = false;
    public static ScanState scanState = ScanState.NONE;

    static {
        JFC_RespackoptsConfig.ensureInitialized();
    }

    public static enum ScanState {
        NONE,
        SCANNING,
        DONE;

    }

    public static class Tweaker {
        public static ConfigBuilder<?> tweak(ConfigBuilder<?> builder) {
            Path dir = Platform.getInstance().getConfigDir().resolve("respackopts");
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return (ConfigBuilder)builder.setPath(dir.resolve("_respackopts.conf")).referenceConfig(() -> {
                if (scanState != ScanState.DONE) {
                    return List.of();
                }
                LinkedList instances = new LinkedList();
                MetaCache.forEach((key, state) -> instances.add(DSL.create((String)state.packId()).config(cb -> state.configBranch().buildConfig(cb, key.dataLocation()))));
                return instances;
            });
        }
    }
}

