/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePaletteResizer;
import fi.dy.masa.litematica.schematic.container.LitematicaBitArray;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStatePaletteHashMap;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStatePaletteLinear;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.stream.LongStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class LitematicaBlockStateContainer
implements ILitematicaBlockStatePaletteResizer {
    private static final Codec<ILitematicaBlockStatePalette> PALETTE_CODEC = Codec.either(LitematicaBlockStatePaletteHashMap.CODEC, LitematicaBlockStatePaletteLinear.CODEC).xmap(either -> (ILitematicaBlockStatePalette)either.map(type -> type, type -> type), type -> {
        Either either;
        if (type instanceof LitematicaBlockStatePaletteHashMap) {
            LitematicaBlockStatePaletteHashMap hashMap = (LitematicaBlockStatePaletteHashMap)type;
            either = Either.left((Object)hashMap);
        } else if (type instanceof LitematicaBlockStatePaletteLinear) {
            LitematicaBlockStatePaletteLinear linear = (LitematicaBlockStatePaletteLinear)type;
            either = Either.right((Object)linear);
        } else {
            either = null;
        }
        return either;
    });
    public static final Codec<LitematicaBlockStateContainer> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("Bits").forGetter(get -> get.bits), (App)LitematicaBitArray.CODEC.fieldOf("Storage").forGetter(get -> get.storage), (App)PALETTE_CODEC.fieldOf("Palette").forGetter(get -> get.palette), (App)PrimitiveCodec.INT.fieldOf("SizeX").forGetter(get -> get.sizeX), (App)PrimitiveCodec.INT.fieldOf("SizeY").forGetter(get -> get.sizeY), (App)PrimitiveCodec.INT.fieldOf("SizeZ").forGetter(get -> get.sizeZ), (App)PrimitiveCodec.INT.fieldOf("SizeLayer").forGetter(get -> get.sizeLayer), (App)class_2382.field_25123.fieldOf("Size").forGetter(get -> get.size), (App)PrimitiveCodec.LONG.fieldOf("TotalVolume").forGetter(get -> get.totalVolume), (App)PrimitiveCodec.LONG_STREAM.optionalFieldOf("BlockCounts", (Object)LongStream.empty()).forGetter(get -> Arrays.stream(get.blockCounts))).apply((Applicative)inst, LitematicaBlockStateContainer::new));
    public static final class_9139<ByteBuf, LitematicaBlockStateContainer> PACKET_CODEC = new class_9139<ByteBuf, LitematicaBlockStateContainer>(){

        public void encode(@Nonnull ByteBuf buf, LitematicaBlockStateContainer value) {
            LitematicaBitArray.PACKET_CODEC.encode((Object)buf, (Object)value.storage);
            class_9135.field_49675.encode((Object)buf, (Object)value.bits);
            ILitematicaBlockStatePalette iLitematicaBlockStatePalette = value.palette;
            if (iLitematicaBlockStatePalette instanceof LitematicaBlockStatePaletteHashMap) {
                LitematicaBlockStatePaletteHashMap hash = (LitematicaBlockStatePaletteHashMap)iLitematicaBlockStatePalette;
                LitematicaBlockStatePaletteHashMap.PACKET_CODEC.encode((Object)buf, (Object)hash);
            } else {
                iLitematicaBlockStatePalette = value.palette;
                if (iLitematicaBlockStatePalette instanceof LitematicaBlockStatePaletteLinear) {
                    LitematicaBlockStatePaletteLinear linear = (LitematicaBlockStatePaletteLinear)iLitematicaBlockStatePalette;
                    LitematicaBlockStatePaletteLinear.PACKET_CODEC.encode((Object)buf, (Object)linear);
                } else {
                    throw new RuntimeException();
                }
            }
            class_9135.field_49675.encode((Object)buf, (Object)value.sizeX);
            class_9135.field_49675.encode((Object)buf, (Object)value.sizeY);
            class_9135.field_49675.encode((Object)buf, (Object)value.sizeZ);
            class_9135.field_49675.encode((Object)buf, (Object)value.sizeLayer);
            class_2382.field_56131.encode((Object)buf, (Object)value.size);
            class_9135.field_54505.encode((Object)buf, (Object)value.totalVolume);
            class_9135.field_57046.encode((Object)buf, (Object)value.blockCounts);
        }

        @Nonnull
        public LitematicaBlockStateContainer decode(@Nonnull ByteBuf buf) {
            LitematicaBitArray storage = (LitematicaBitArray)LitematicaBitArray.PACKET_CODEC.decode((Object)buf);
            int bits = (Integer)class_9135.field_49675.decode((Object)buf);
            ILitematicaBlockStatePalette palette = bits <= 4 ? (ILitematicaBlockStatePalette)LitematicaBlockStatePaletteLinear.PACKET_CODEC.decode((Object)buf) : (ILitematicaBlockStatePalette)LitematicaBlockStatePaletteHashMap.PACKET_CODEC.decode((Object)buf);
            return new LitematicaBlockStateContainer(bits, storage, palette, (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (class_2382)class_2382.field_56131.decode((Object)buf), (Long)class_9135.field_54505.decode((Object)buf), Arrays.stream((long[])class_9135.field_57046.decode((Object)buf)));
        }
    };
    public static final class_2680 AIR_BLOCK_STATE = class_2246.field_10124.method_9564();
    protected LitematicaBitArray storage;
    protected ILitematicaBlockStatePalette palette;
    protected final class_2382 size;
    protected final int sizeX;
    protected final int sizeY;
    protected final int sizeZ;
    protected final int sizeLayer;
    protected final long totalVolume;
    protected int bits;
    protected long[] blockCounts = new long[0];

    public LitematicaBlockStateContainer(int sizeX, int sizeY, int sizeZ) {
        this(sizeX, sizeY, sizeZ, 2, null);
    }

    public LitematicaBlockStateContainer(class_2382 size, int bits, @Nullable long[] backingLongArray) {
        this(size.method_10263(), size.method_10264(), size.method_10260(), bits, backingLongArray);
    }

    public LitematicaBlockStateContainer(int sizeX, int sizeY, int sizeZ, int bits, @Nullable long[] backingLongArray) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.sizeLayer = sizeX * sizeZ;
        this.totalVolume = (long)this.sizeX * (long)this.sizeY * (long)this.sizeZ;
        this.size = new class_2382(this.sizeX, this.sizeY, this.sizeZ);
        this.setBits(bits, backingLongArray);
    }

    private LitematicaBlockStateContainer(Integer bits, LitematicaBitArray bitArray, ILitematicaBlockStatePalette palette, Integer x, Integer y, Integer z, Integer layer, class_2382 size, Long volume, LongStream counts) {
        this.bits = bits;
        this.storage = bitArray;
        this.palette = palette;
        this.sizeX = x;
        this.sizeY = y;
        this.sizeZ = z;
        this.sizeLayer = layer;
        this.size = size;
        this.totalVolume = volume;
        if (!counts.equals(LongStream.empty())) {
            this.blockCounts = counts.toArray();
        }
    }

    public class_2382 getSize() {
        return this.size;
    }

    public LitematicaBitArray getArray() {
        return this.storage;
    }

    public long[] getBlockCounts() {
        return this.blockCounts;
    }

    public class_2680 get(int x, int y, int z) {
        class_2680 state = this.palette.getBlockState(this.storage.getAt(this.getIndex(x, y, z)));
        return state == null ? AIR_BLOCK_STATE : state;
    }

    public void set(int x, int y, int z, class_2680 state) {
        int id = this.palette.idFor(state);
        this.storage.setAt(this.getIndex(x, y, z), id);
    }

    protected void set(int index, class_2680 state) {
        int id = this.palette.idFor(state);
        this.storage.setAt(index, id);
    }

    protected int getIndex(int x, int y, int z) {
        return y * this.sizeLayer + z * this.sizeX + x;
    }

    protected void setBits(int bitsIn, @Nullable long[] backingLongArray) {
        if (bitsIn != this.bits) {
            this.bits = bitsIn;
            if (this.bits <= 4) {
                this.bits = Math.max(2, this.bits);
                this.palette = new LitematicaBlockStatePaletteLinear(this.bits, this);
            } else {
                this.palette = new LitematicaBlockStatePaletteHashMap(this.bits, this);
            }
            this.palette.idFor(AIR_BLOCK_STATE);
            this.storage = backingLongArray != null ? new LitematicaBitArray(this.bits, this.totalVolume, backingLongArray) : new LitematicaBitArray(this.bits, this.totalVolume);
        }
    }

    @Override
    public int onResize(int bits, class_2680 state) {
        LitematicaBitArray oldStorage = this.storage;
        ILitematicaBlockStatePalette oldPalette = this.palette;
        long storageLength = oldStorage.size();
        this.setBits(bits, null);
        LitematicaBitArray newStorage = this.storage;
        for (long index = 0L; index < storageLength; ++index) {
            newStorage.setAt(index, oldStorage.getAt(index));
        }
        this.palette.readFromNBT(oldPalette.writeToNBT());
        return this.palette.idFor(state);
    }

    public long[] getBackingLongArray() {
        return this.storage.getBackingLongArray();
    }

    public ILitematicaBlockStatePalette getPalette() {
        return this.palette;
    }

    public static LitematicaBlockStateContainer createFrom(class_2499 palette, long[] blockStates, class_2338 size) {
        int bits = Math.max(2, 32 - Integer.numberOfLeadingZeros(palette.size() - 1));
        LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(size.method_10263(), size.method_10264(), size.method_10260(), bits, blockStates);
        container.palette.readFromNBT(palette);
        return container;
    }

    @Nullable
    public static LitematicaBlockStateContainer createContainer(int paletteSize, byte[] blockData, class_2382 size) {
        int bits = Math.max(2, 32 - Integer.numberOfLeadingZeros(paletteSize - 1));
        SpongeBlockstateConverterResults results = LitematicaBlockStateContainer.convertVarIntByteArrayToPackedLongArray(size, bits, blockData);
        LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(size, bits, results.backingArray);
        container.blockCounts = results.blockCounts;
        return container;
    }

    public static SpongeBlockstateConverterResults convertVarIntByteArrayToPackedLongArray(class_2382 size, int bits, byte[] blockStates) {
        int volume = size.method_10263() * size.method_10264() * size.method_10260();
        LitematicaBitArray bitArray = new LitematicaBitArray(bits, volume);
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])blockStates));
        long[] blockCounts = new long[1 << bits];
        for (int i = 0; i < volume; ++i) {
            int id = buf.method_10816();
            bitArray.setAt(i, id);
            int n = id;
            blockCounts[n] = blockCounts[n] + 1L;
        }
        return new SpongeBlockstateConverterResults(bitArray.getBackingLongArray(), blockCounts);
    }

    public static class SpongeBlockstateConverterResults {
        public final long[] backingArray;
        public final long[] blockCounts;

        protected SpongeBlockstateConverterResults(long[] backingArray, long[] blockCounts) {
            this.backingArray = backingArray;
            this.blockCounts = blockCounts;
        }
    }
}

