/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Lookup<T> {
    private DataSegment<T> data = UnionDataSegment.empty();

    public boolean load(Stream<? extends DataSegment<T>> data, Lookup<T> parent) {
        return this.load(Stream.of(parent.data, UnionDataSegment.of(data)));
    }

    public boolean load(Stream<? extends DataSegment<T>> data) {
        this.data = UnionDataSegment.of(data);
        return !this.data.isEmpty();
    }

    public SoundsKey getAssociation(T state, String substrate) {
        return this.data.getAssociation(state, substrate).orElse(SoundsKey.UNASSIGNED);
    }

    public Set<String> getSubstrates() {
        return this.data.getSubstrates();
    }

    public Map<String, SoundsKey> getAssociations(T state) {
        Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
        for (String substrate : this.getSubstrates()) {
            SoundsKey association = this.getAssociation(state, substrate);
            if (!association.isResult()) continue;
            result.put(substrate, association);
        }
        return Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectOpenHashMap((Map)result));
    }

    public boolean contains(T state) {
        return this.data.contains(state);
    }

    public boolean contains(T state, String substrate) {
        return this.data.contains(state, substrate);
    }

    record UnionDataSegment<T>(List<? extends DataSegment<T>> entries, Set<String> substrates) implements DataSegment<T>
    {
        static final UnionDataSegment<?> EMPTY = new UnionDataSegment(List.of(), Set.of());

        public static <T> DataSegment<T> empty() {
            return EMPTY;
        }

        public static <T> DataSegment<T> of(Stream<? extends DataSegment<T>> entries) {
            SequencedCollection data = entries.filter(i -> !i.isEmpty()).toList().reversed();
            if (data.size() == 1) {
                return (DataSegment)data.get(0);
            }
            if (data.size() == 0) {
                return UnionDataSegment.empty();
            }
            Set<String> substrates = data.stream().flatMap(i -> i.getSubstrates().stream()).distinct().collect(Collectors.toUnmodifiableSet());
            return new UnionDataSegment<T>(data, substrates);
        }

        @Override
        public Optional<SoundsKey> getAssociation(T state, String substrate) {
            for (DataSegment<T> segment : this.entries) {
                Optional<SoundsKey> key = segment.getAssociation(state, substrate);
                if (!key.isPresent()) continue;
                return key;
            }
            return Optional.empty();
        }

        @Override
        public Set<String> getSubstrates() {
            return this.substrates;
        }

        @Override
        public boolean contains(T state) {
            for (DataSegment<T> segment : this.entries) {
                if (!segment.contains(state)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(T state, String substrate) {
            for (DataSegment<T> segment : this.entries) {
                if (!segment.contains(state, substrate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }
    }

    public static interface DataSegment<T> {
        public Optional<SoundsKey> getAssociation(T var1, String var2);

        public Set<String> getSubstrates();

        public boolean contains(T var1);

        public boolean contains(T var1, String var2);

        public boolean isEmpty();
    }
}

