/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.ha3.presencefootsteps.util.MathUtil;
import java.util.Random;
import net.minecraft.class_3532;

public record Range(float min, float max) {
    private static final Codec<Float> PERCENTAGE_CODEC = Codec.FLOAT.xmap(i -> Float.valueOf(i.floatValue() / 100.0f), i -> Float.valueOf(i.floatValue() * 100.0f));
    private static final Codec<Range> RANGE_CODEC = RecordCodecBuilder.create(i -> i.group((App)PERCENTAGE_CODEC.fieldOf("min").forGetter(Range::min), (App)PERCENTAGE_CODEC.fieldOf("max").forGetter(Range::max)).apply((Applicative)i, Range::new));
    private static final Codec<Range> POINT_CODEC = PERCENTAGE_CODEC.xmap(Range::exactly, Range::min);
    public static final Codec<Range> CODEC = Codec.xor(POINT_CODEC, RANGE_CODEC).xmap(either -> (Range)Either.unwrap((Either)either), i -> class_3532.method_15347((float)i.min(), (float)i.max()) ? Either.left((Object)i) : Either.right((Object)i));
    public static final Range DEFAULT = Range.exactly(1.0f);

    public static Range exactly(float value) {
        return new Range(value, value);
    }

    @Deprecated
    public Range read(String name, JsonObject json) {
        if ("volume".equals(name) && (json.has("vol") || json.has("vol_min") || json.has("vol_max"))) {
            return this.read("vol", json);
        }
        if (json.has(name)) {
            JsonElement element = json.get(name);
            if (element.isJsonObject()) {
                return new Range(Range.getPercentage(element.getAsJsonObject(), "min", this.min), Range.getPercentage(element.getAsJsonObject(), "max", this.max));
            }
            return Range.exactly(Range.getPercentage(json, name, this.min));
        }
        return new Range(Range.getPercentage(json, name + "_min", this.min), Range.getPercentage(json, name + "_max", this.max));
    }

    public float random(Random rand) {
        return MathUtil.randAB(rand, this.min, this.max);
    }

    public float on(float value) {
        return class_3532.method_16439((float)value, (float)this.min, (float)this.max);
    }

    private static float getPercentage(JsonObject object, String param, float fallback) {
        if (!object.has(param)) {
            return fallback;
        }
        return object.get(param).getAsFloat() / 100.0f;
    }
}

