/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.generator.MineLP;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.QuadrupedModifier;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.WingedStepSoundGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_746;

public enum Locomotion {
    NONE,
    BIPED((entity, engine) -> new TerrestrialStepSoundGenerator((class_1309)entity, (SoundEngine)engine, new Modifier<TerrestrialStepSoundGenerator>())),
    QUADRUPED((entity, engine) -> new TerrestrialStepSoundGenerator((class_1309)entity, (SoundEngine)engine, new QuadrupedModifier())),
    FLYING((entity, engine) -> new WingedStepSoundGenerator((class_1309)entity, (SoundEngine)engine, new QuadrupedModifier())),
    FLYING_BIPED((entity, engine) -> new WingedStepSoundGenerator((class_1309)entity, (SoundEngine)engine, new Modifier<TerrestrialStepSoundGenerator>()));

    private static final Map<String, Locomotion> registry;
    private final BiFunction<class_1309, SoundEngine, Optional<StepSoundGenerator>> constructor;
    private static final String AUTO_TRANSLATION_KEY = "menu.pf.stance.auto";
    private final String translationKey = "menu.pf.stance." + this.name().toLowerCase(Locale.ROOT);

    private Locomotion() {
        this.constructor = (entity, engine) -> Optional.empty();
    }

    private Locomotion(BiFunction<class_1309, SoundEngine, StepSoundGenerator> gen) {
        this.constructor = (entity, engine) -> Optional.of((StepSoundGenerator)gen.apply((class_1309)entity, (SoundEngine)engine));
    }

    public Optional<StepSoundGenerator> supplyGenerator(class_1309 entity, SoundEngine engine) {
        return this.constructor.apply(entity, engine);
    }

    public class_2561 getOptionName() {
        return class_2561.method_43469((String)"menu.pf.stance", (Object[])new Object[]{class_2561.method_43471((String)(this == NONE ? AUTO_TRANSLATION_KEY : this.translationKey))});
    }

    public class_2561 getOptionTooltip() {
        return class_2561.method_43471((String)(this.translationKey + ".tooltip"));
    }

    public static Locomotion byName(String name) {
        return registry.getOrDefault(name, BIPED);
    }

    public static Locomotion forLiving(class_1297 entity, Locomotion fallback) {
        if (MineLP.hasPonies()) {
            return MineLP.getLocomotion(entity, fallback);
        }
        return fallback;
    }

    public static Locomotion forPlayer(class_1657 ply, Locomotion preference) {
        if (preference == NONE) {
            if (ply instanceof class_746 && MineLP.hasPonies()) {
                return MineLP.getLocomotion(ply);
            }
            return BIPED;
        }
        return preference;
    }

    static {
        registry = new Object2ObjectOpenHashMap();
        for (Locomotion i : Locomotion.values()) {
            registry.put(i.name(), i);
            registry.put(String.valueOf(i.ordinal()), i);
        }
    }
}

