/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.api.DerivedBlock;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.SoundsKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11630;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PFDebugHud
implements class_11632 {
    public static final class_2960 ID = PresenceFootsteps.id("hud");
    private final SoundEngine engine;

    PFDebugHud(SoundEngine engine) {
        this.engine = engine;
    }

    public boolean method_72753(boolean reducedDebugInfo) {
        return true;
    }

    public void method_72751(class_11630 finalList, @Nullable class_1937 world, @Nullable class_2818 clientChunk, @Nullable class_2818 chunk) {
        class_3966 ehr;
        class_3965 blockHit;
        class_310 client = class_310.method_1551();
        PFConfig config = this.engine.getConfig();
        finalList.method_72744(class_11631.field_61579, List.of("", String.valueOf(class_124.field_1073) + "Presence Footsteps " + String.valueOf(((ModContainer)FabricLoader.getInstance().getModContainer("presencefootsteps").get()).getMetadata().getVersion()), String.format("Enabled: %s, Multiplayer: %s, Running: %s", config.getEnabled(), config.getEnabledMP(), this.engine.isRunning(client)), String.format("Volume: Global[G: %s%%, W: %s%%, F: %s%%]", config.getGlobalVolume(), config.wetSoundsVolume, config.foliageSoundsVolume), String.format("Entities[H: %s%%, P: %s%%], Players[U: %s%%, T: %s%% ]", config.hostileEntitiesVolume, config.passiveEntitiesVolume, config.clientPlayerVolume, config.otherPlayerVolume), String.format("Stepping Mode: %s, Targeting Mode: %s, Footwear: %s", config.getLocomotion() == Locomotion.NONE ? String.format("AUTO (%sDETECTED %s%s)", new Object[]{class_124.field_1067, Locomotion.forPlayer((class_1657)client.field_1724, Locomotion.NONE), class_124.field_1070}) : config.getLocomotion(), config.getEntitySelector(), config.getEnabledFootwear()), String.format("Data Loaded: B%s P%s G%s", this.engine.getIsolator().globalBlocks().getSubstrates().size(), this.engine.getIsolator().primitives().getSubstrates().size(), this.engine.getIsolator().golems().getSubstrates().size()), String.format("Has Resource Pack: %s%s", this.engine.hasData() ? class_124.field_1060 : class_124.field_1061, this.engine.hasData())));
        class_239 class_2392 = client.field_1765;
        if (class_2392 instanceof class_3965 && (blockHit = (class_3965)class_2392).method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = blockHit.method_17777();
            class_2680 state = client.field_1687.method_8320(pos);
            class_2338 above = pos.method_10084();
            class_2680 base = DerivedBlock.getBaseOf(state);
            boolean hasRain = client.field_1687.method_8419() && ((class_1959)client.field_1687.method_23753(above).comp_349()).method_48162(above, client.field_1687.method_8615()) == class_1959.class_1963.field_9382;
            boolean hasLava = client.field_1687.method_8320(above).method_26227().method_15767(class_3486.field_15518);
            boolean hasWater = client.field_1687.method_8520(above) || state.method_26227().method_15767(class_3486.field_15517) || client.field_1687.method_8320(above).method_26227().method_15767(class_3486.field_15517);
            finalList.method_72744(class_11631.field_61564, List.of("", String.valueOf(class_124.field_1073) + "Targeted Block Sounds Like"));
            if (!base.method_26215()) {
                finalList.method_72743(class_11631.field_61564, class_7923.field_41175.method_10221((Object)base.method_26204()).toString());
            }
            finalList.method_72744(class_11631.field_61564, List.of(String.format(Locale.ENGLISH, "Primitive Key: %s", PrimitiveLookup.getKey(state.method_26231())), "Surface Condition: " + (hasLava ? String.valueOf(class_124.field_1061) + "LAVA" : (hasWater ? String.valueOf(class_124.field_1078) + "WET" : (hasRain ? String.valueOf(class_124.field_1080) + "SHELTERED" : String.valueOf(class_124.field_1080) + "DRY")))));
            finalList.method_72744(class_11631.field_61564, this.renderSoundList("Step Sounds[B]", this.engine.getIsolator().globalBlocks().getAssociations(state)));
            finalList.method_72744(class_11631.field_61564, this.renderSoundList("Step Sounds[P]", this.engine.getIsolator().primitives().getAssociations(state.method_26231().method_10594())));
            finalList.method_72743(class_11631.field_61564, "");
        }
        if ((class_2392 = client.field_1765) instanceof class_3966 && (ehr = (class_3966)class_2392).method_17782() != null) {
            finalList.method_72743(class_11631.field_61566, String.format("Targeted Entity Step Mode: %s", new Object[]{this.engine.getIsolator().locomotions().lookup(ehr.method_17782())}));
            finalList.method_72744(class_11631.field_61566, this.renderSoundList("Step Sounds[G]", this.engine.getIsolator().golems().getAssociations(ehr.method_17782().method_5864())));
        }
    }

    private List<String> renderSoundList(String title, Map<String, SoundsKey> sounds) {
        if (sounds.isEmpty()) {
            return List.of();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder combinedList = new StringBuilder(String.valueOf(class_124.field_1073) + title + String.valueOf(class_124.field_1070) + ": [ ");
        boolean first = true;
        for (Map.Entry<String, SoundsKey> entry : sounds.entrySet()) {
            if (!first) {
                combinedList.append(" / ");
            }
            first = false;
            if (!entry.getKey().isEmpty()) {
                combinedList.append(entry.getKey()).append(":");
            }
            combinedList.append(entry.getValue().raw());
        }
        combinedList.append(" ]");
        list.add(combinedList.toString());
        if (!list.isEmpty()) {
            return list;
        }
        if (sounds.isEmpty()) {
            list.add(SoundsKey.UNASSIGNED.raw());
        } else {
            sounds.forEach((key, value) -> list.add((key.isEmpty() ? "default" : key) + ": " + value.raw()));
        }
        return list;
    }
}

