/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_408.class})
public class ChatScreenMixin {
    @Unique
    private boolean wasOpenedLastFrame = false;
    @Unique
    private long lastOpenTime = 0L;
    @Unique
    private float offsetY = 0.0f;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void renderStart(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && !this.wasOpenedLastFrame && !client.field_1724.method_6113()) {
            this.wasOpenedLastFrame = true;
            this.lastOpenTime = System.currentTimeMillis();
        }
        float FADE_TIME = 170.0f;
        float FADE_OFFSET = 8.0f;
        float screenFactor = (float)client.method_22683().method_4507() / 1080.0f;
        float timeSinceOpen = Math.min((float)(System.currentTimeMillis() - this.lastOpenTime), FADE_TIME);
        float alpha = 1.0f - timeSinceOpen / FADE_TIME;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        float modifiedAlpha = c3 * alpha * alpha * alpha - c1 * alpha * alpha;
        this.offsetY = modifiedAlpha * FADE_OFFSET * screenFactor;
        context.method_51448().translate(0.0f, this.offsetY);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V", shift=At.Shift.AFTER)})
    private void renderEnd(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.method_51448().translate(0.0f, -this.offsetY);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;render(Lnet/minecraft/client/gui/DrawContext;IIF)V", shift=At.Shift.BEFORE)})
    private void renderScreenStart(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.method_51448().translate(0.0f, this.offsetY);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;render(Lnet/minecraft/client/gui/DrawContext;IIF)V", shift=At.Shift.AFTER)})
    private void renderScreenEnd(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.method_51448().translate(0.0f, -this.offsetY);
    }

    @Inject(method={"removed"}, at={@At(value="HEAD")})
    private void onClosed(CallbackInfo ci) {
        this.wasOpenedLastFrame = false;
    }
}

