/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxCUresult
extends NativeObject {
    public static final int SIZEOF;
    public static final int ALIGNOF = 8;

    protected PxCUresult() {
    }

    private static native int __sizeOf();

    public static PxCUresult wrapPointer(long address) {
        return address != 0L ? new PxCUresult(address) : null;
    }

    public static PxCUresult arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxCUresult.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxCUresult(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        PxCUresult._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    static {
        PlatformChecks.requirePlatform(3, "physx.common.PxCUresult");
        SIZEOF = PxCUresult.__sizeOf();
    }
}

