/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.ragdoll.TrapdoorRagdoll;
import net.diebuddies.physics.vines.Adjustable;
import net.diebuddies.physics.vines.DynamicSetting;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TrapdoorSetting
extends DynamicSetting {
    @Adjustable(id="Hitbox scale", min=0.1, max=10.0, step=0.01, translationId="physicsmod.prop.trapdoor.hitboxscale")
    public Vector3f hitboxScale;
    @Adjustable(id="Stiffness", min=0.1, max=5000.0, step=0.1, translationId="physicsmod.prop.trapdoor.stiffness")
    public float stiffness;
    @Adjustable(id="Damping", min=0.1, max=100.0, step=0.1, translationId="physicsmod.prop.trapdoor.damping")
    public float damping;
    @Adjustable(id="Collision", min=0.1, max=100.0, step=0.1, translationId="physicsmod.prop.trapdoor.collision")
    public boolean collision;

    public TrapdoorSetting(Vector3f hitboxScale, float stiffness, float damping, boolean linkedPhysics, boolean collision) {
        this.collision = collision;
        this.hitboxScale = hitboxScale;
        this.stiffness = stiffness;
        this.damping = damping;
        this.linkedPhysics = linkedPhysics;
    }

    public TrapdoorSetting() {
        this.collision = true;
        this.hitboxScale = new Vector3f(0.85f);
        this.stiffness = 1580.0f;
        this.damping = 8.0f;
        this.linkedPhysics = true;
    }

    @Override
    public DynamicRagdoll createRagdoll(PhysicsMod mod, class_2680 current, class_2338 pos, Long2ObjectMap<class_2680> availableBlocks) {
        TrapdoorRagdoll ragdoll = new TrapdoorRagdoll();
        ragdoll.hitboxScale.set((Vector3fc)this.hitboxScale);
        ragdoll.hookedEntity = this.createPart(mod, ragdoll, current, pos.method_10264(), pos.method_10263(), pos.method_10264(), pos.method_10260());
        ragdoll.stiffness = this.stiffness;
        ragdoll.damping = this.damping;
        ragdoll.linkedPhysics = this.linkedPhysics;
        ragdoll.collision = this.collision;
        Vector3d hookPos = new Vector3d();
        hookPos.y = current.method_11654((class_2769)class_2533.field_11625) == class_2760.field_12619 ? 0.90625 : 0.09375;
        switch ((class_2350)current.method_11654((class_2769)class_2533.field_11177)) {
            default: {
                hookPos.z = 0.90625;
                break;
            }
            case field_11035: {
                hookPos.z = 0.09375;
                break;
            }
            case field_11039: {
                hookPos.x = 0.90625;
                ragdoll.west = true;
                break;
            }
            case field_11034: {
                hookPos.x = 0.09375;
                ragdoll.west = true;
            }
        }
        Vector3f offset = ragdoll.hookedEntity.models.get((int)0).mesh.offset;
        hookPos.x -= (double)offset.x % 1.0;
        hookPos.y -= (double)offset.y % 1.0;
        hookPos.z -= (double)offset.z % 1.0;
        ragdoll.hook = hookPos;
        availableBlocks.remove(ChunkHelper.calcRelativeIndex(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        return ragdoll;
    }

    @Override
    public boolean isValid(class_2680 state) {
        return state.method_28498((class_2769)class_2533.field_11177) && state.method_28498((class_2769)class_2533.field_11631) && state.method_28498((class_2769)class_2533.field_11625);
    }

    @Override
    public class_2248 defaultBlock() {
        return class_2246.field_10137;
    }
}

