/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.snow.math;

import java.util.List;
import net.diebuddies.physics.snow.Triangle;
import net.diebuddies.physics.snow.math.BoundingSphere;
import net.diebuddies.physics.snow.math.RayHit;
import net.diebuddies.physics.snow.math.RayResult;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Ray {
    private static final double EPSILON = 1.0E-7;
    private Vector3d start;
    private Vector3d direction;

    public Ray(Vector3d start, Vector3d direction) {
        this.start = start;
        this.direction = direction;
    }

    public Vector3d intersect(Triangle triangle) {
        Vector3d e2;
        Vector3d h;
        Vector3d e1 = triangle.p1.sub((Vector3dc)triangle.p0, new Vector3d());
        double a = e1.dot((Vector3dc)(h = this.direction.cross((Vector3dc)(e2 = triangle.p2.sub((Vector3dc)triangle.p0, new Vector3d())), new Vector3d())));
        if (a > -1.0E-7 && a < 1.0E-7) {
            return null;
        }
        double f = 1.0 / a;
        Vector3d s = this.start.sub((Vector3dc)triangle.p0, new Vector3d());
        double u = f * s.dot((Vector3dc)h);
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        Vector3d q = s.cross((Vector3dc)e1, new Vector3d());
        double v = f * this.direction.dot((Vector3dc)q);
        if (v < 0.0 || u + v > 1.0) {
            return null;
        }
        double t = f * e2.dot((Vector3dc)q);
        if (t > 1.0E-7) {
            Vector3d intersection = this.direction.mul(t, new Vector3d()).add((Vector3dc)this.start);
            return intersection;
        }
        return null;
    }

    public RayResult intersect(List<Triangle> mesh, boolean rayLengthAsMaxDistance) {
        RayResult result = new RayResult();
        double length = this.getDirection().length();
        for (Triangle t : mesh) {
            Vector3d hit = this.intersect(t);
            if (hit == null || rayLengthAsMaxDistance && !(hit.distance((Vector3dc)this.getStart()) < length)) continue;
            result.addRayHit(new RayHit(t.calculateNormal(), hit));
        }
        result.sortByDistance(this.start);
        return result;
    }

    public RayResult intersect(Vector3d position, Vector3d normal) {
        double t;
        RayResult result = new RayResult();
        double denom = normal.dot((Vector3dc)this.direction);
        if (Math.abs(denom) > 1.0E-5 && (t = position.sub((Vector3dc)this.start, new Vector3d()).dot((Vector3dc)normal) / denom) >= 0.0) {
            result.addRayHit(new RayHit(new Vector3d((Vector3dc)normal), new Vector3d((Vector3dc)this.start).add((Vector3dc)this.direction.mul(t, new Vector3d()))));
        }
        return result;
    }

    public boolean intersectTest(List<Triangle> mesh, boolean rayLengthAsMaxDistance) {
        double length = this.getDirection().length();
        for (Triangle t : mesh) {
            Vector3d hit = this.intersect(t);
            if (hit == null || rayLengthAsMaxDistance && !(hit.distance((Vector3dc)this.getStart()) < length)) continue;
            return true;
        }
        return false;
    }

    public RayResult intersect(List<Triangle> mesh) {
        return this.intersect(mesh, false);
    }

    public RayResult intersect(BoundingSphere boundingSphere) {
        RayResult result = new RayResult();
        Vector3d centerToPoint = this.start.sub((Vector3dc)boundingSphere.center, new Vector3d());
        Vector3d normalizedDirection = new Vector3d((Vector3dc)this.direction).normalize();
        double b = centerToPoint.dot((Vector3dc)normalizedDirection);
        double c = centerToPoint.dot((Vector3dc)centerToPoint) - boundingSphere.radius * boundingSphere.radius;
        if (c > 0.0 && b > 0.0) {
            return result;
        }
        double discr = b * b - c;
        if (discr < 0.0) {
            return result;
        }
        double t = -b - Math.sqrt(discr);
        if (t < 0.0) {
            t = 0.0;
        }
        Vector3d hitPoint = this.start.add((Vector3dc)normalizedDirection.mul(t, new Vector3d()), new Vector3d());
        result.addRayHit(new RayHit(boundingSphere.center.sub((Vector3dc)hitPoint, new Vector3d()).normalize(), hitPoint));
        return result;
    }

    public Vector3d getStart() {
        return this.start;
    }

    public Vector3d getDirection() {
        return this.direction;
    }
}

