/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.LabelOption;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsSubScreen;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class SmokeSettingsScreen
extends LegacyOptionsSubScreen {
    private LegacyOptionsList list;
    private static final CycleOption<Boolean> PHYSICS_SMOKE = CycleOption.createOnOff("physicsmod.menu.smoke.smokephysics", gameOptions -> ConfigClient.smokePhysics, (gameOptions, option, value) -> {
        ConfigClient.smokePhysics = value;
        ConfigClient.save();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            mod.getPhysicsWorld().getSmokeDomain().clearParticles();
        }
    });
    private final CycleOption<Boolean> PHYSICS_CUDA_SMOKE = CycleOption.createOnOff("physicsmod.menu.smoke.cudasmoke", gameOptions -> ConfigClient.cudaSmoke, (gameOptions, option, value) -> {
        if (((CycleOption)option).active) {
            ConfigClient.cudaSmoke = value;
            ConfigClient.save();
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.getPhysicsWorld().destroy();
            }
            PhysicsMod.getInstances().clear();
            StarterClient.createPhysicsCooking(ConfigClient.useCuda());
            this.list.method_25396().clear();
            class_310.method_1551().method_1507((class_437)new SmokeSettingsScreen(this.lastScreen, this.options));
        }
    }).setTooltip(minecraft -> graphicsStatus -> {
        if (!StarterClient.cudaAvailable) {
            return class_2561.method_43471((String)"physicsmod.menu.smoke.cudasmoke.error");
        }
        return class_2561.method_43471((String)"physicsmod.menu.smoke.cudasmoke.info");
    });
    private static final ProgressOption PHYSICS_SMOKE_DISTANCE = new ProgressOption("physicsmod.menu.smoke.smokephysicsrange", 1.0, 400.0, 0.1f, gameOptions -> ConfigClient.smokePhysicsRange, (gameOptions, value) -> {
        ConfigClient.smokePhysicsRange = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.smokephysicsrange", String.format("%.0f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_SMOKE_BRIGHTNESS = new ProgressOption("physicsmod.menu.smoke.smokedensity", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.smokeDensity, (gameOptions, value) -> {
        ConfigClient.smokeDensity = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.smokedensity", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_SMOKE_PARTICLE_LIMIT = new ProgressOption("physicsmod.menu.smoke.smokeparticlelimit", 1.0, ConfigClient.cudaSmoke() ? 200000.0 : 40000.0, 0.1f, gameOptions -> {
        if (ConfigClient.cudaSmoke()) {
            return ConfigClient.smokeParticleLimitCuda;
        }
        return ConfigClient.smokeParticleLimit;
    }, (gameOptions, value) -> {
        if (ConfigClient.cudaSmoke()) {
            ConfigClient.smokeParticleLimitCuda = value.intValue();
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.getPhysicsWorld().destroy();
            }
            PhysicsMod.getInstances().clear();
        } else {
            ConfigClient.smokeParticleLimit = value.intValue();
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.getPhysicsWorld().getSmokeDomain().clearParticles();
            }
        }
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.smokeparticlelimit", String.format("%.0f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_SMOKE = new ProgressOption("physicsmod.menu.smoke.particlelifetimesmoke", 0.0, 300.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeSmoke, (gameOptions, value) -> {
        ConfigClient.particleLifetimeSmoke = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.particlelifetimesmoke", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_SMOKE = new ProgressOption("physicsmod.menu.smoke.particlelifetimevariancesmoke", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceSmoke, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceSmoke = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.particlelifetimevariancesmoke", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_DESPAWN_TIME_SMOKE = new ProgressOption("physicsmod.menu.smoke.particledespawntimesmoke", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleDespawnTimeSmoke, (gameOptions, value) -> {
        ConfigClient.particleDespawnTimeSmoke = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.particledespawntimesmoke", String.format("%.2f", option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.smoke.particledespawntimesmoke.info"));
    private static final ProgressOption PHYSICS_DESPAWN_TIME_VARIANCE_SMOKE = new ProgressOption("physicsmod.menu.smoke.particledespawntimevariancesmoke", 0.0, 30.0, 0.1f, gameOptions -> {
        if (ConfigClient.cudaSmoke()) {
            return ConfigClient.particleDespawnTimeVarianceSmokeCuda;
        }
        return ConfigClient.particleDespawnTimeVarianceSmoke;
    }, (gameOptions, value) -> {
        if (ConfigClient.cudaSmoke()) {
            ConfigClient.particleDespawnTimeVarianceSmokeCuda = value;
        } else {
            ConfigClient.particleDespawnTimeVarianceSmoke = value;
        }
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.particledespawntimevariancesmoke", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_COLOR_RED = new ProgressOption("physicsmod.menu.smoke.red", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.smokeColorRed, (gameOptions, value) -> {
        ConfigClient.smokeColorRed = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.red", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_COLOR_GREEN = new ProgressOption("physicsmod.menu.smoke.green", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.smokeColorGreen, (gameOptions, value) -> {
        ConfigClient.smokeColorGreen = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.green", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_COLOR_BLUE = new ProgressOption("physicsmod.menu.smoke.blue", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.smokeColorBlue, (gameOptions, value) -> {
        ConfigClient.smokeColorBlue = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.blue", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_DENSE_COLOR_RED = new ProgressOption("physicsmod.menu.smoke.red", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.smokeDenseColorRed, (gameOptions, value) -> {
        ConfigClient.smokeDenseColorRed = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.red", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_DENSE_COLOR_GREEN = new ProgressOption("physicsmod.menu.smoke.green", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.smokeDenseColorGreen, (gameOptions, value) -> {
        ConfigClient.smokeDenseColorGreen = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.green", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_DENSE_COLOR_BLUE = new ProgressOption("physicsmod.menu.smoke.blue", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.smokeDenseColorBlue, (gameOptions, value) -> {
        ConfigClient.smokeDenseColorBlue = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.blue", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_SMOKE_FIRE = new ProgressOption("physicsmod.menu.smoke.fire", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.smokeFire, (gameOptions, value) -> {
        ConfigClient.smokeFire = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.fire", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_SMOKE_CAMPFIRE = new ProgressOption("physicsmod.menu.smoke.campfire", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.smokeCampfire, (gameOptions, value) -> {
        ConfigClient.smokeCampfire = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.campfire", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_SMOKE_BLAZE = new ProgressOption("physicsmod.menu.smoke.blaze", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.smokeBlaze, (gameOptions, value) -> {
        ConfigClient.smokeBlaze = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.blaze", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_SMOKE_OTHER = new ProgressOption("physicsmod.menu.smoke.other", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.smokeOther, (gameOptions, value) -> {
        ConfigClient.smokeOther = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.smoke.other", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final int MAX_INFO_WIDTH = 350;
    private List<class_5481> info;
    private LabelOption denseColor;
    private LabelOption color;

    public SmokeSettingsScreen(class_437 parent, class_315 options) {
        super(parent, options, (class_2561)class_2561.method_43471((String)"physicsmod.menu.smoke.title"));
        this.info = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"physicsmod.menu.smoke.warning"), 350);
    }

    protected void method_25426() {
        this.list = new LegacyOptionsList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.field_22786.add(this.list);
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 + 5, this.field_22790 - 27, 75, 20, class_5244.field_24334, button -> {
            this.method_25419();
            this.field_22787.method_1507(this.lastScreen);
        }));
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 - 80, this.field_22790 - 27, 75, 20, (class_2561)class_2561.method_43471((String)"physicsmod.gui.reset"), button -> PopupWidget.create(class_2477.method_10517().method_48307("physicsmod.menu.smoke.reset"), this, widget -> this.method_37063((class_364)widget), widget -> this.method_37066((class_364)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetSmokeSettings();
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new SmokeSettingsScreen(this.lastScreen, this.options));
                for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                    mod.getPhysicsWorld().getSmokeDomain().clearParticles();
                }
            } else {
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new SmokeSettingsScreen(this.lastScreen, this.options));
            }
        })));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.list.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        int lineY = 0;
        for (class_5481 sequence : this.info) {
            guiGraphics.method_35720(this.field_22793, sequence, (this.field_22789 - 350) / 2, 8 + lineY, -171);
            lineY += 10;
        }
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        if (this.color != null && this.color.label != null) {
            if (SmokeSettingsScreen.PHYSICS_COLOR_RED.widget != null && SmokeSettingsScreen.PHYSICS_COLOR_RED.widget.method_25367() || SmokeSettingsScreen.PHYSICS_COLOR_GREEN.widget != null && SmokeSettingsScreen.PHYSICS_COLOR_GREEN.widget.method_25367() || SmokeSettingsScreen.PHYSICS_COLOR_BLUE.widget != null && SmokeSettingsScreen.PHYSICS_COLOR_BLUE.widget.method_25367()) {
                this.color.label.field_22763 = false;
                int r = Math.max(0, Math.min((int)(SmokeSettingsScreen.PHYSICS_COLOR_RED.widget.getValue() * 255.0), 255));
                int g = Math.max(0, Math.min((int)(SmokeSettingsScreen.PHYSICS_COLOR_GREEN.widget.getValue() * 255.0), 255));
                int b = Math.max(0, Math.min((int)(SmokeSettingsScreen.PHYSICS_COLOR_BLUE.widget.getValue() * 255.0), 255));
                int hexColor = (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
                this.color.setInactiveColor(hexColor);
            } else {
                this.color.label.field_22763 = true;
            }
        }
        if (this.denseColor != null && this.denseColor.label != null) {
            if (SmokeSettingsScreen.PHYSICS_DENSE_COLOR_RED.widget != null && SmokeSettingsScreen.PHYSICS_DENSE_COLOR_RED.widget.method_25367() || SmokeSettingsScreen.PHYSICS_DENSE_COLOR_GREEN.widget != null && SmokeSettingsScreen.PHYSICS_DENSE_COLOR_GREEN.widget.method_25367() || SmokeSettingsScreen.PHYSICS_DENSE_COLOR_BLUE.widget != null && SmokeSettingsScreen.PHYSICS_DENSE_COLOR_BLUE.widget.method_25367()) {
                this.denseColor.label.field_22763 = false;
                int rd = Math.max(0, Math.min((int)(SmokeSettingsScreen.PHYSICS_DENSE_COLOR_RED.widget.getValue() * 255.0), 255));
                int gd = Math.max(0, Math.min((int)(SmokeSettingsScreen.PHYSICS_DENSE_COLOR_GREEN.widget.getValue() * 255.0), 255));
                int bd = Math.max(0, Math.min((int)(SmokeSettingsScreen.PHYSICS_DENSE_COLOR_BLUE.widget.getValue() * 255.0), 255));
                int hexDenseColor = (rd & 0xFF) << 16 | (gd & 0xFF) << 8 | (bd & 0xFF) << 0;
                this.denseColor.setInactiveColor(hexDenseColor);
            } else {
                this.denseColor.label.field_22763 = true;
            }
        }
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }
}

