/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.liquid;

import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.PhysicsIndex;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.liquid.LiquidController;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import org.joml.Random;
import org.joml.Vector3d;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.NativeObject;
import physx.common.PxCudaContext;
import physx.common.PxCudaContextManager;
import physx.common.PxCudaTopLevelFunctions;
import physx.common.PxVec4;
import physx.particles.PxParticleBuffer;
import physx.particles.PxParticleBufferDesc;
import physx.particles.PxParticleBufferFlagEnum;

public class LiquidCuda
extends Liquid {
    private static final float SPAWN_ANIMATION_TIME = 0.1f;
    private static final float DESPAWN_ANIMATION_TIME = 2.0f;
    private static final float SPAWN_INV_ANIMATION_TIME = 10.0f;
    private static final float DESPAWN_INV_ANIMATION_TIME = 0.5f;
    private static final class_2338.class_2339 tmpPos = new class_2338.class_2339();
    private int maxLiquid;
    private ParticleInfo[] particles;
    private float[] cudaPositions;
    private float[] cudaOldPositions;
    private PxParticleBuffer particleBuffer;
    private FloatBuffer positionsBuffer;
    private FloatBuffer velocitiesBuffer;
    private IntBuffer phaseBuffer;
    private List<Vector3d> bufferedSpawns = new ObjectArrayList();
    private Random random;
    private int activeParticles;

    public LiquidCuda(LiquidController controller) {
        super(controller);
        this.maxLiquid = ConfigClient.liquidCudaMaxParticles;
        this.sourceAlive = true;
        this.particles = new ParticleInfo[this.maxLiquid];
        this.random = new Random(System.nanoTime());
    }

    @Override
    public boolean update(PhysicsWorld physicsWorld, double diff) {
        this.controller.update(this, diff);
        if (this.hasBufferedParticles() || this.hasParticles()) {
            PxCudaContextManager cudaMgr = StarterClient.cudaManager;
            cudaMgr.acquireContext();
            PxCudaContext cudaContext = cudaMgr.getCudaContext();
            if (this.particleBuffer == null) {
                this.createParticleBuffers(physicsWorld, cudaContext);
            }
            this.fetchPositions(cudaContext, diff);
            this.processBufferedParticles(physicsWorld, cudaContext);
            long positionsAddress = MemoryUtil.memAddress((FloatBuffer)this.positionsBuffer);
            long velocitiesAddress = MemoryUtil.memAddress((FloatBuffer)this.velocitiesBuffer);
            long phaseAddress = MemoryUtil.memAddress((IntBuffer)this.phaseBuffer);
            cudaContext.memcpyHtoD(PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getPositionInvMasses()), NativeObject.wrapPointer(positionsAddress), PxVec4.SIZEOF * this.activeParticles);
            cudaContext.memcpyHtoD(PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getVelocities()), NativeObject.wrapPointer(velocitiesAddress), PxVec4.SIZEOF * this.activeParticles);
            cudaContext.memcpyHtoD(PxCudaTopLevelFunctions.pxU32deviceptr(this.particleBuffer.getPhases()), NativeObject.wrapPointer(phaseAddress), 4 * this.activeParticles);
            this.particleBuffer.setNbActiveParticles(this.activeParticles);
            this.particleBuffer.raiseFlags(PxParticleBufferFlagEnum.eUPDATE_POSITION);
            this.particleBuffer.raiseFlags(PxParticleBufferFlagEnum.eUPDATE_VELOCITY);
            this.particleBuffer.raiseFlags(PxParticleBufferFlagEnum.eUPDATE_PHASE);
            cudaMgr.releaseContext();
        }
        return !this.sourceAlive && this.particleCount() == 0;
    }

    private void createParticleBuffers(PhysicsWorld physicsWorld, PxCudaContext cudaContext) {
        try (MemoryStack mem = MemoryStack.stackPush();){
            PxParticleBufferDesc bufferDesc = PxParticleBufferDesc.createAt(mem, MemoryStack::nmalloc);
            bufferDesc.setMaxParticles(this.maxLiquid);
            bufferDesc.setNumActiveParticles(0);
            this.positionsBuffer = MemoryUtil.memAllocFloat((int)(this.maxLiquid * 4));
            this.velocitiesBuffer = MemoryUtil.memAllocFloat((int)(this.maxLiquid * 4));
            this.phaseBuffer = MemoryUtil.memAllocInt((int)this.maxLiquid);
            this.cudaPositions = new float[this.maxLiquid * 4];
            this.cudaOldPositions = new float[this.maxLiquid * 4];
            PxCudaContextManager cudaMgr = StarterClient.cudaManager;
            this.particleBuffer = PxCudaTopLevelFunctions.CreateAndPopulateParticleBuffer(bufferDesc, cudaMgr);
            physicsWorld.getFluidSystem().addParticleBuffer(this.particleBuffer);
        }
    }

    private boolean hasBufferedParticles() {
        return this.bufferedSpawns.size() != 0;
    }

    private boolean hasParticles() {
        return this.activeParticles != 0;
    }

    private void fetchPositions(PxCudaContext cudaContext, double diff) {
        if (!this.hasParticles()) {
            return;
        }
        long positionsAddress = MemoryUtil.memAddress((FloatBuffer)this.positionsBuffer);
        long velocitiesAddress = MemoryUtil.memAddress((FloatBuffer)this.velocitiesBuffer);
        long phaseAddress = MemoryUtil.memAddress((IntBuffer)this.phaseBuffer);
        cudaContext.memcpyDtoH(NativeObject.wrapPointer(positionsAddress), PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getPositionInvMasses()), PxVec4.SIZEOF * this.activeParticles);
        cudaContext.memcpyDtoH(NativeObject.wrapPointer(velocitiesAddress), PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getVelocities()), PxVec4.SIZEOF * this.activeParticles);
        cudaContext.memcpyDtoH(NativeObject.wrapPointer(phaseAddress), PxCudaTopLevelFunctions.pxU32deviceptr(this.particleBuffer.getPhases()), 4 * this.activeParticles);
        System.arraycopy(this.cudaPositions, 0, this.cudaOldPositions, 0, this.activeParticles * 4);
        this.positionsBuffer.get(0, this.cudaPositions, 0, this.activeParticles * 4);
        for (int i = 0; i < this.activeParticles; ++i) {
            ParticleInfo particle = this.particles[i];
            int arrOffset = i * 4;
            float posX = this.cudaPositions[arrOffset];
            float posY = this.cudaPositions[arrOffset + 1];
            float posZ = this.cudaPositions[arrOffset + 2];
            particle.loadChunkPhysics(this.world, posX, posY, posZ);
            particle.lifetime = (float)((double)particle.lifetime - diff);
            if (!(particle.lifetime <= 0.0f)) continue;
            particle.unloadChunkPhysics(this.world);
            this.removeParticleBuffer(i--);
        }
    }

    private void removeParticleBuffer(int index) {
        --this.activeParticles;
        int currentPos = index * 4;
        int oldPos = this.activeParticles * 4;
        this.positionsBuffer.put(currentPos, this.positionsBuffer, oldPos, 4);
        this.velocitiesBuffer.put(currentPos, this.velocitiesBuffer, oldPos, 4);
        this.phaseBuffer.put(index, this.phaseBuffer, this.activeParticles, 1);
        this.particles[index] = this.particles[this.activeParticles];
        this.particles[this.activeParticles] = null;
        this.cudaPositions[currentPos] = this.cudaPositions[oldPos];
        this.cudaPositions[currentPos + 1] = this.cudaPositions[oldPos + 1];
        this.cudaPositions[currentPos + 2] = this.cudaPositions[oldPos + 2];
        this.cudaOldPositions[currentPos] = this.cudaOldPositions[oldPos];
        this.cudaOldPositions[currentPos + 1] = this.cudaOldPositions[oldPos + 1];
        this.cudaOldPositions[currentPos + 2] = this.cudaOldPositions[oldPos + 2];
    }

    @Override
    public void spawnParticle(double x, double y, double z) {
        this.bufferedSpawns.add(new Vector3d(x + (double)this.random.nextFloat() * 0.1 - 0.05, y + (double)this.random.nextFloat() * 0.1 - 0.05, z + (double)this.random.nextFloat() * 0.1 - 0.05));
    }

    public void processBufferedParticles(PhysicsWorld physicsWorld, PxCudaContext cudaContext) {
        if (!this.hasBufferedParticles()) {
            return;
        }
        Vector3d offset = this.world.getOffset();
        int needed = this.bufferedSpawns.size();
        int quickDespawn = needed - (this.maxLiquid - this.activeParticles);
        for (int i = 0; i < quickDespawn && this.activeParticles > 0; ++i) {
            int index = this.random.nextInt(this.activeParticles);
            ParticleInfo particle = this.particles[index];
            this.removeParticleBuffer(index);
            particle.unloadChunkPhysics(this.world);
        }
        int free = this.maxLiquid - this.activeParticles;
        if (free == 0) {
            this.bufferedSpawns.clear();
            return;
        }
        int fluidPhase = physicsWorld.getFluidPhase();
        for (int i = 0; i < this.bufferedSpawns.size() && i < free; ++i) {
            int id = this.activeParticles;
            Vector3d bufferedSpawn = this.bufferedSpawns.get(i);
            double x = bufferedSpawn.x;
            double y = bufferedSpawn.y;
            double z = bufferedSpawn.z;
            this.world.adjustOffset(x, y, z);
            int fillOld = id * 4;
            this.cudaPositions[fillOld] = (float)(x -= offset.x);
            this.cudaPositions[fillOld + 1] = (float)(y -= offset.y);
            this.cudaPositions[fillOld + 2] = (float)(z -= offset.z);
            this.cudaOldPositions[fillOld] = (float)x;
            this.cudaOldPositions[fillOld + 1] = (float)y;
            this.cudaOldPositions[fillOld + 2] = (float)z;
            this.positionsBuffer.put(id * 4, new float[]{(float)x, (float)y, (float)z, 10.0f});
            this.velocitiesBuffer.put(id * 4, new float[4]);
            this.phaseBuffer.put(id, fluidPhase);
            ParticleInfo particle = new ParticleInfo(this);
            particle.lifetimeTotal = particle.lifetime = (float)java.lang.Math.max((double)2.1f, ConfigClient.particleLifetimeLiquidsCuda + (double)Math.random() * ConfigClient.particleLifetimeVarianceLiquidsCuda);
            this.particles[this.activeParticles] = particle;
            ++this.activeParticles;
        }
        this.bufferedSpawns.clear();
    }

    @Override
    public int particleCount() {
        return this.activeParticles;
    }

    @Override
    public int fillInstances(PhysicsWorld physicsWorld, float[] fluidpos, float[] fluidposnew, byte[] fluidlight, int offset) {
        Vector3d physicsOffset = physicsWorld.getOffset();
        for (int i = 0; i < this.activeParticles; ++i) {
            this.prepareFluidInstances(physicsWorld, physicsWorld.getLevel(), i, physicsOffset.x, physicsOffset.y, physicsOffset.z, i + offset, fluidpos, fluidposnew, fluidlight);
        }
        return this.activeParticles;
    }

    private void prepareFluidInstances(PhysicsWorld physics, class_1937 level, int particleIndex, double ox, double oy, double oz, int index, float[] fluidpos, float[] fluidposnew, byte[] fluidlight) {
        ParticleInfo particle = this.particles[particleIndex];
        int srcOffset = particleIndex * 4;
        float x = this.cudaPositions[srcOffset];
        float y = this.cudaPositions[srcOffset + 1];
        float z = this.cudaPositions[srcOffset + 2];
        int brightness = particle.getLight(level, tmpPos.method_10102(ox + (double)x, oy + (double)y, oz + (double)z));
        int dstOffset = index * 4;
        float scale = java.lang.Math.min(1.0f, particle.lifetime * 0.5f);
        float spawnAnimation = particle.lifetimeTotal - particle.lifetime;
        if (spawnAnimation <= 0.1f) {
            scale = spawnAnimation * 10.0f;
        }
        fluidlight[dstOffset] = (byte)(brightness >> 4 & 0xF | brightness >> 16 & 0xF0);
        fluidpos[dstOffset] = this.cudaOldPositions[srcOffset];
        fluidpos[dstOffset + 1] = this.cudaOldPositions[srcOffset + 1];
        fluidpos[dstOffset + 2] = this.cudaOldPositions[srcOffset + 2];
        fluidpos[dstOffset + 3] = 1.0f;
        fluidposnew[dstOffset] = this.cudaPositions[srcOffset];
        fluidposnew[dstOffset + 1] = this.cudaPositions[srcOffset + 1];
        fluidposnew[dstOffset + 2] = this.cudaPositions[srcOffset + 2];
        fluidposnew[dstOffset + 3] = physics.fluidParticleSize * scale * 1.2f;
    }

    @Override
    public void invalidateBrightness(LongSet updatedLightBlocks) {
        super.invalidateBrightness(updatedLightBlocks);
        for (int i = 0; i < this.activeParticles; ++i) {
            long pos;
            ParticleInfo particle = this.particles[i];
            class_2338.class_2339 cached = particle.getCachedBrightnessPos();
            if (cached == null || !updatedLightBlocks.contains(pos = cached.method_10063())) continue;
            particle.invalidateBrightness();
        }
    }

    private void remove(PhysicsWorld world) {
        if (this.particleBuffer == null) {
            return;
        }
        PxCudaContextManager cudaMgr = StarterClient.cudaManager;
        cudaMgr.acquireContext();
        world.getFluidSystem().removeParticleBuffer(this.particleBuffer);
        this.particleBuffer.release();
        this.particleBuffer = null;
        MemoryUtil.memFree((Buffer)this.positionsBuffer);
        MemoryUtil.memFree((Buffer)this.velocitiesBuffer);
        MemoryUtil.memFree((Buffer)this.phaseBuffer);
        this.activeParticles = 0;
        cudaMgr.releaseContext();
    }

    @Override
    public void destroy(PhysicsWorld world) {
        this.remove(world);
    }

    private class ParticleInfo {
        public float lifetime;
        public float lifetimeTotal;
        private long lastChunk = Long.MAX_VALUE;
        private int cachedBrightness;
        private class_2338.class_2339 cachedBrightnessPos;

        private ParticleInfo(LiquidCuda liquidCuda) {
        }

        public void loadChunkPhysics(PhysicsWorld world, float x, float y, float z) {
            int cz;
            int cy;
            Vector3d offset = world.getOffset();
            int cx = class_3532.method_15357((double)((double)x + offset.x)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS;
            long chunkIndex = PhysicsIndex.pack(cx, cy = class_3532.method_15357((double)((double)y + offset.y)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS, cz = class_3532.method_15357((double)((double)z + offset.z)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS);
            if (chunkIndex != this.lastChunk) {
                if (this.lastChunk != Long.MAX_VALUE) {
                    world.removeLoadedChunkEntity(this.lastChunk);
                }
                this.lastChunk = chunkIndex;
                world.addLoadedChunkEntity(this.lastChunk);
            }
        }

        public void unloadChunkPhysics(PhysicsWorld world) {
            if (this.lastChunk != Long.MAX_VALUE) {
                world.removeLoadedChunkEntity(this.lastChunk);
                this.lastChunk = Long.MAX_VALUE;
            }
        }

        public int getLight(class_1937 level, class_2338.class_2339 blockPos) {
            if (!StarterClient.disableLightingCache) {
                if (this.cachedBrightnessPos == null) {
                    this.cachedBrightnessPos = new class_2338.class_2339(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                } else if (this.cachedBrightnessPos.method_10263() == blockPos.method_10263() && this.cachedBrightnessPos.method_10264() == blockPos.method_10264() && this.cachedBrightnessPos.method_10260() == blockPos.method_10260()) {
                    return this.cachedBrightness;
                }
            }
            class_2680 bState = level.method_8320((class_2338)blockPos);
            int x = blockPos.method_10263();
            int y = blockPos.method_10264();
            int z = blockPos.method_10260();
            int brightness = 0;
            if (!bState.method_26225()) {
                brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
            } else {
                bState = level.method_8320((class_2338)blockPos.method_10103(x, y + 1, z));
                if (!bState.method_26225()) {
                    brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                } else {
                    bState = level.method_8320((class_2338)blockPos.method_10103(x, y - 1, z));
                    if (!bState.method_26225()) {
                        brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                    } else {
                        bState = level.method_8320((class_2338)blockPos.method_10103(x, y, z - 1));
                        if (!bState.method_26225()) {
                            brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                        } else {
                            bState = level.method_8320((class_2338)blockPos.method_10103(x + 1, y, z));
                            if (!bState.method_26225()) {
                                brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                            } else {
                                bState = level.method_8320((class_2338)blockPos.method_10103(x, y, z + 1));
                                if (!bState.method_26225()) {
                                    brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                                } else {
                                    bState = level.method_8320((class_2338)blockPos.method_10103(x - 1, y, z));
                                    if (!bState.method_26225()) {
                                        brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            blockPos.method_10103(x, y, z);
            if (!StarterClient.disableLightingCache) {
                this.cachedBrightness = brightness;
                this.cachedBrightnessPos.method_10103(x, y, z);
            }
            return brightness;
        }

        public class_2338.class_2339 getCachedBrightnessPos() {
            return this.cachedBrightnessPos;
        }

        public void invalidateBrightness() {
            this.cachedBrightnessPos = null;
        }
    }
}

