/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.sodium;

import java.nio.ByteOrder;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.render.immediate.model.EntityRenderer;
import net.caffeinemc.mods.sodium.client.render.immediate.model.ModelCuboid;
import net.diebuddies.opengl.TextureHelper;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.render.BlockEntityBufferSource;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(value={EntityRenderer.class})
public class MixinEntityRenderer {
    @Shadow(remap=false)
    @Final
    private static long[] CUBE_VERTEX_XY;
    @Shadow(remap=false)
    @Final
    private static long[] CUBE_VERTEX_ZW;
    @Unique
    private static class_630 sodiumPart;
    @Unique
    private static final boolean LITTLE;

    @Inject(at={@At(value="HEAD")}, method={"renderCuboids"}, remap=false)
    private static void physicsmod$renderCuboids(class_4587.class_4665 matrices, VertexBufferWriter writer, ModelCuboid[] cuboids, int light, int overlay, int color, CallbackInfo info) {
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        if (mod != null && mod.blockify && sodiumPart != null) {
            PhysicsMod.createParticlesFromCuboids(matrices, mod.localPivotMatrix, MixinEntityRenderer.sodiumPart.field_3663, mod.cubifyEntity, mod.cubifyEntityRenderer, mod.blockifyFeature, mod.cubifyTranslucent, overlay, (float)ColorABGR.unpackRed((int)color) / 255.0f, (float)ColorABGR.unpackGreen((int)color) / 255.0f, (float)ColorABGR.unpackBlue((int)color) / 255.0f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, remap=false)
    private static void physicsmod$renderHead(class_4587 matrixStack, VertexBufferWriter writer, class_630 part, int light, int overlay, int color, CallbackInfo info) {
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        if (mod != null && mod.blockify && part.field_3665) {
            sodiumPart = part;
            mod.localPivotMatrix.method_22903();
            part.method_22703(mod.localPivotMatrix);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render"}, remap=false)
    private static void physicsmod$renderTail(class_4587 matrixStack, VertexBufferWriter writer, class_630 part, int light, int overlay, int color, CallbackInfo info) {
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        if (mod != null && mod.blockify && part.field_3665) {
            mod.localPivotMatrix.method_22909();
            sodiumPart = null;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"writeVertex"}, remap=false)
    private static void physicsmod$catchRenderingForBlockEntities(long ptr, int vertexIndex, long packedUv, long packedOverlayLight, int normal, CallbackInfoReturnable<Long> info) {
        float z;
        float y;
        float x;
        if (PhysicsMod.sodiumCatchBoundingBox) {
            x = Float.intBitsToFloat(MixinEntityRenderer.unpackA(CUBE_VERTEX_XY[vertexIndex]));
            y = Float.intBitsToFloat(MixinEntityRenderer.unpackB(CUBE_VERTEX_XY[vertexIndex]));
            z = Float.intBitsToFloat(MixinEntityRenderer.unpackA(CUBE_VERTEX_ZW[vertexIndex]));
            Vector3d start = PhysicsMod.sodiumBoundingBox.start;
            Vector3d end = PhysicsMod.sodiumBoundingBox.end;
            if ((double)x < start.x) {
                start.x = x;
            }
            if ((double)y < start.y) {
                start.y = y;
            }
            if ((double)z < start.z) {
                start.z = z;
            }
            if ((double)x > end.x) {
                end.x = x;
            }
            if ((double)y > end.y) {
                end.y = y;
            }
            if ((double)z > end.z) {
                end.z = z;
            }
        }
        if (PhysicsMod.sodiumCatch) {
            x = Float.intBitsToFloat(MixinEntityRenderer.unpackA(CUBE_VERTEX_XY[vertexIndex]));
            y = Float.intBitsToFloat(MixinEntityRenderer.unpackB(CUBE_VERTEX_XY[vertexIndex]));
            z = Float.intBitsToFloat(MixinEntityRenderer.unpackA(CUBE_VERTEX_ZW[vertexIndex]));
            int color = MixinEntityRenderer.unpackB(CUBE_VERTEX_ZW[vertexIndex]);
            float u = Float.intBitsToFloat(MixinEntityRenderer.unpackA(packedUv));
            float v = Float.intBitsToFloat(MixinEntityRenderer.unpackB(packedUv));
            Model model = BlockEntityBufferSource.currentConsumer.getModel();
            if (model == null) {
                return;
            }
            model.textureID = TextureHelper.getLoadedTextures();
            Mesh mesh = model.mesh;
            mesh.positions.add(new Vector3f(x, y, z));
            float normRange = 0.007874016f;
            float normX = (float)((byte)(normal & 0xFF)) * normRange;
            float normY = (float)((byte)(normal >> 8 & 0xFF)) * normRange;
            float normZ = (float)((byte)(normal >> 16 & 0xFF)) * normRange;
            mesh.colors.add(color);
            mesh.normals.add(new Vector3f(normX, normY, normZ));
            mesh.uvs.add(new Vector2f(u, v));
            if ((mesh.positions.size() & 3) == 0) {
                int index = mesh.positions.size() - 4;
                mesh.indices.add(index);
                mesh.indices.add(index + 1);
                mesh.indices.add(index + 2);
                mesh.indices.add(index);
                mesh.indices.add(index + 2);
                mesh.indices.add(index + 3);
            }
        }
    }

    @Unique
    private static int unpackA(long packed) {
        return LITTLE ? (int)(packed & 0xFFFFFFFFL) : (int)(packed >>> 32 & 0xFFFFFFFFL);
    }

    @Unique
    private static int unpackB(long packed) {
        return LITTLE ? (int)(packed >>> 32 & 0xFFFFFFFFL) : (int)(packed & 0xFFFFFFFFL);
    }

    static {
        LITTLE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    }
}

