/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import java.util.Random;
import net.diebuddies.physics.Mesh;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderHelper {
    private static Random random = new Random();

    public static void renderMesh(class_11659 submitNodeCollector, int seed, float rotation, class_2960 texture, Mesh mesh, class_4587 poseStack, int light, int overlay, boolean shade) {
        Matrix4f transformation = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        random.setSeed(seed);
        transformation.rotateX(random.nextFloat() * (float)Math.PI);
        transformation.rotateY(random.nextFloat() * (float)Math.PI);
        transformation.rotateZ(random.nextFloat() * (float)Math.PI + rotation * 0.5f);
        Matrix3f normalMatrix = transformation.normal(new Matrix3f());
        if (!shade) {
            normalMatrix.set((Matrix3fc)poseStack.method_23760().method_23762());
        }
        submitNodeCollector.method_73483(poseStack, class_1921.method_23572((class_2960)texture), (pose, consumer) -> {
            Vector3f tmpPos = new Vector3f();
            Vector3f tmpNormal = new Vector3f();
            for (int i = 0; i < mesh.indicesQuads.size(); ++i) {
                int index = mesh.indicesQuads.getInt(i);
                Vector3f position = mesh.positions.get(index);
                Vector2f uv = mesh.uvs.get(index);
                Vector3f normal = mesh.normals.get(index);
                position = transformation.transformPosition((Vector3fc)position, tmpPos);
                if (shade) {
                    tmpNormal.set(normal.x, normal.y, normal.z);
                } else {
                    tmpNormal.set(0.0, 1.0, 0.0);
                }
                normalMatrix.transform(tmpNormal);
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (mesh.colors.size() > 0) {
                    int color = mesh.colors.getInt(index);
                    r = (float)(color & 0xFF) / 255.0f;
                    g = (float)(color >> 8 & 0xFF) / 255.0f;
                    b = (float)(color >> 16 & 0xFF) / 255.0f;
                }
                consumer.method_22912(position.x, position.y, position.z).method_22915(r, g, b, 1.0f).method_22913(uv.x, uv.y).method_22922(overlay).method_60803(light).method_22914(tmpNormal.x, tmpNormal.y, tmpNormal.z);
            }
        });
    }
}

